/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.PoweredRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PoweredRollingMachineBlock
extends BaseEntityBlock
implements ChargeBlock,
JeiSearchable {
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.RECHARGEABLE, 8000, 1000, 1.0f));
    private static final MapCodec<PoweredRollingMachineBlock> CODEC = PoweredRollingMachineBlock.simpleCodec(PoweredRollingMachineBlock::new);

    public PoweredRollingMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PoweredRollingMachineBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : PoweredRollingMachineBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get()), ManualRollingMachineBlockEntity::serverTick);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get()).ifPresent(blockEntity -> serverPlayer.openMenu((MenuProvider)blockEntity, pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.registerNode(state, level, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.is(oldState.getBlock())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof PoweredRollingMachineBlockEntity) {
            PoweredRollingMachineBlockEntity rollingMachine = (PoweredRollingMachineBlockEntity)blockEntity;
            rollingMachine.dropContents(level, pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, moved);
        if (!state.is(newState.getBlock())) {
            this.deregisterNode((ServerLevel)level, pos);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)Translations.Tips.ROLLING_MACHINE).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.POWERED_ROLLING_MACHINE);
    }
}

