/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.charge;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.level.block.charge.ChargeBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BatteryBlock
extends ChargeBlock
implements JeiSearchable {
    private static final VoxelShape SHAPE = Shapes.create((AABB)BoxBuilder.create().box().raiseCeiling(-0.0625).build());

    public BatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Charge.distribution.network(serverLevel).access(pos).zap(entity, Charge.DamageOrigin.BLOCK, 1.0f);
        }
    }

    protected abstract ChargeBlock.Spec getChargeSpec();

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return Collections.singletonMap(Charge.distribution, this.getChargeSpec());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.CHARGE_NETWORK_BATTERY).withStyle(ChatFormatting.BLUE));
        ChargeBlock.Spec spec = this.getChargeSpec();
        boolean isRechargeable = spec.storageSpec().initialState().equals((Object)ChargeStorage.State.RECHARGEABLE);
        int capacity = spec.storageSpec().capacity() / 1000;
        int maxDraw = spec.storageSpec().maxDraw();
        float loss = spec.losses();
        int efficiency = (int)(spec.storageSpec().efficiency() * 100.0f);
        tooltip.add((Component)Component.translatable((String)(isRechargeable ? Translations.Tips.TYPE_RECHARGEABLE : Translations.Tips.TYPE_DISPOSABLE)).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.CAPACITY, (Object[])new Object[]{capacity}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.MAX_DRAW, (Object[])new Object[]{maxDraw}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.LOSS, (Object[])new Object[]{Float.valueOf(loss)}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.EFFICIENCY, (Object[])new Object[]{efficiency}).withStyle(ChatFormatting.GRAY));
    }
}

