/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FilterDetectorBlockEntity
extends DetectorBlockEntity
implements MenuProvider,
ContainerManipulator<ModifiableSlotAccessor> {
    protected final AdvancedContainer invFilters;

    protected FilterDetectorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState);
        this.invFilters = new AdvancedContainer(inventorySize).listener(this).phantom();
    }

    public AdvancedContainer getInvFilters() {
        return this.invFilters;
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.invFilters.stream();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.invFilters.fromTag(tag.getList("container", 10), provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("container", (Tag)this.invFilters.createTag(provider));
    }
}

