/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.util.ItemStackKey;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerManifest;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.ItemManipulatorMenu;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class ItemManipulatorBlockEntity
extends ManipulatorBlockEntity
implements MenuProvider {
    protected static final Map<ManipulatorBlockEntity.TransferMode, Predicate<ItemManipulatorBlockEntity>> modeHasWork = new EnumMap<ManipulatorBlockEntity.TransferMode, Predicate<ItemManipulatorBlockEntity>>(ManipulatorBlockEntity.TransferMode.class);
    protected ContainerManipulator<?> cart;
    protected ContainerManipulator<? extends SlotAccessor> chests = ContainerManipulator.empty();
    protected final Multiset<ItemStackKey> transferredItems = HashMultiset.create();
    protected final ContainerMapper bufferContainer;
    private final AdvancedContainer filtersContainer = new AdvancedContainer(9).listener(this).phantom();
    private ManipulatorBlockEntity.TransferMode transferMode = ManipulatorBlockEntity.TransferMode.ALL;

    protected ItemManipulatorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.setContainerSize(9);
        this.bufferContainer = ContainerMapper.make(this.container()).ignoreItemChecks();
    }

    public abstract ContainerManipulator<?> getSource();

    public abstract ContainerManipulator<?> getDestination();

    public ManipulatorBlockEntity.TransferMode getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(ManipulatorBlockEntity.TransferMode transferMode) {
        this.transferMode = transferMode;
    }

    public final AdvancedContainer getItemFilters() {
        return this.filtersContainer;
    }

    public abstract Slot getBufferSlot(int var1, int var2, int var3);

    @Override
    protected void setPowered(boolean powered) {
        if (!this.isSendCartGateAction() && this.getRedstoneMode() == ManipulatorBlockEntity.RedstoneMode.MANUAL) {
            super.setPowered(false);
            return;
        }
        super.setPowered(powered);
    }

    @Override
    protected void reset() {
        super.reset();
        this.transferredItems.clear();
    }

    @Nullable
    protected static IItemHandler getCartItemHandler(AbstractMinecart cart, Direction direction) {
        return (IItemHandler)cart.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)direction);
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
        this.chests = ContainerManipulator.of(this.bufferContainer, this.findAdjacentContainers());
        IItemHandler cartInv = ItemManipulatorBlockEntity.getCartItemHandler(cart, this.getFacing().getOpposite());
        if (cartInv == null) {
            this.sendCart(cart);
            return;
        }
        this.cart = ContainerManipulator.of(cartInv);
        ContainerManifest filterManifest = ContainerManifest.create(this.getItemFilters());
        Stream<ContainerManifest.ManifestEntry> manifestStream = filterManifest.values().stream();
        switch (this.getTransferMode()) {
            case ALL: {
                if (filterManifest.isEmpty()) {
                    ItemStack moved = this.getSource().moveOneItemTo(this.getDestination());
                    this.itemMoved(moved);
                    break;
                }
                this.moveItem(manifestStream);
                break;
            }
            case TRANSFER: {
                this.moveItem(manifestStream.filter(entry -> this.transferredItems.count((Object)entry.key()) < entry.count()));
                break;
            }
            case STOCK: {
                ContainerManifest destManifest = ContainerManifest.create(this.getDestination(), (Collection<ItemStackKey>)filterManifest.keySet());
                this.moveItem(manifestStream.filter(entry -> destManifest.count(entry.key()) < entry.count()));
                break;
            }
            case EXCESS: {
                ContainerManifest sourceManifest = ContainerManifest.create(this.getSource(), (Collection<ItemStackKey>)filterManifest.keySet());
                this.moveItem(manifestStream.filter(entry -> sourceManifest.count(entry.key()) > entry.count()));
                if (this.isProcessing()) break;
                Predicate<ItemStack> canMove = StackFilter.anyMatch(filterManifest.keyStacks()).negate();
                ItemStack moved = this.getSource().moveOneItemTo(this.getDestination(), canMove);
                this.itemMoved(moved);
                break;
            }
        }
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        IItemHandler itemHandler = ItemManipulatorBlockEntity.getCartItemHandler(cart, this.getFacing().getOpposite());
        if (itemHandler == null) {
            return false;
        }
        ContainerManipulator<SlotAccessor> cartInv = ContainerManipulator.of(itemHandler);
        switch (this.getRedstoneMode()) {
            case IMMEDIATE: {
                return false;
            }
            case MANUAL: {
                return true;
            }
            case PARTIAL: {
                if (!cartInv.hasNoItems()) break;
                return true;
            }
        }
        this.cart = cartInv;
        return modeHasWork.get(this.getTransferMode()).test(this);
    }

    protected void moveItem(Stream<ContainerManifest.ManifestEntry> stream) {
        List<ItemStack> keys = stream.map(ContainerManifest.ManifestEntry::key).map(ItemStackKey::copyStack).toList();
        ItemStack moved = this.getSource().moveOneItemTo(this.getDestination(), StackFilter.anyMatch(keys));
        this.itemMoved(moved);
    }

    protected final void itemMoved(ItemStack moved) {
        if (!moved.isEmpty()) {
            this.setProcessing(true);
            this.transferredItems.add((Object)ItemStackKey.make(moved));
        }
    }

    @Override
    public boolean canHandleCart(AbstractMinecart cart) {
        return Optional.ofNullable(ItemManipulatorBlockEntity.getCartItemHandler(cart, this.getFacing().getOpposite())).map(inventory -> inventory.getSlots() > 0).orElse(false) != false && super.canHandleCart(cart);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ItemManipulatorMenu(id, inventory, this);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.transferMode);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.transferMode = (ManipulatorBlockEntity.TransferMode)data.readEnum(ManipulatorBlockEntity.TransferMode.class);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("transferMode", this.transferMode.getSerializedName());
        tag.put("itemFilters", (Tag)this.getItemFilters().createTag(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.transferMode = ManipulatorBlockEntity.TransferMode.fromName(tag.getString("transferMode"));
        this.getItemFilters().fromTag(tag.getList("itemFilters", 10), provider);
    }

    static {
        modeHasWork.put(ManipulatorBlockEntity.TransferMode.ALL, tile -> {
            ContainerManipulator<?> dest = tile.getDestination();
            return tile.getSource().streamItems().filter(StackFilter.anyMatch(tile.getItemFilters())).anyMatch(dest::willAccept);
        });
        modeHasWork.put(ManipulatorBlockEntity.TransferMode.TRANSFER, tile -> {
            ContainerManifest filterManifest = ContainerManifest.create(tile.getItemFilters());
            ContainerManifest sourceManifest = ContainerManifest.create(tile.getSource(), (Collection<ItemStackKey>)filterManifest.keySet());
            ContainerManipulator<?> dest = tile.getDestination();
            return sourceManifest.values().stream().filter(entry -> dest.willAcceptAny(entry.stacks())).anyMatch(entry -> tile.transferredItems.count((Object)entry.key()) < filterManifest.count(entry.key()));
        });
        modeHasWork.put(ManipulatorBlockEntity.TransferMode.STOCK, tile -> {
            ContainerManipulator<?> dest = tile.getDestination();
            ContainerManifest filterManifest = ContainerManifest.create(tile.getItemFilters());
            ContainerManifest sourceManifest = ContainerManifest.create(tile.getSource(), (Collection<ItemStackKey>)filterManifest.keySet());
            ContainerManifest destManifest = ContainerManifest.create(dest, (Collection<ItemStackKey>)filterManifest.keySet());
            return sourceManifest.values().stream().filter(entry -> dest.willAcceptAny(entry.stacks())).anyMatch(entry -> destManifest.count(entry.key()) < filterManifest.count(entry.key()));
        });
        modeHasWork.put(ManipulatorBlockEntity.TransferMode.EXCESS, tile -> {
            ContainerManipulator<?> dest = tile.getDestination();
            ContainerManifest filterManifest = ContainerManifest.create(tile.getItemFilters());
            ContainerManifest sourceManifest = ContainerManifest.create(tile.getSource(), (Collection<ItemStackKey>)filterManifest.keySet());
            if (filterManifest.values().stream().anyMatch(entry -> sourceManifest.count(entry.key()) > entry.count())) {
                return true;
            }
            ContainerManifest remainingManifest = ContainerManifest.create(tile.getSource());
            remainingManifest.keySet().removeIf(stackKey -> StackFilter.anyMatch(tile.getItemFilters()).test(stackKey.itemStack()));
            return remainingManifest.streamValueStacks().anyMatch(dest::willAccept);
        });
    }
}

