/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Collection;
import java.util.function.Predicate;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.ItemStackKey;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerManifest;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.TrainDispenserMenu;
import mods.railcraft.world.item.CartItem;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.CartDispenserBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrainDispenserBlockEntity
extends CartDispenserBlockEntity {
    private static final int PATTERN_SIZE = 9;
    private static final int BUFFER_SIZE = 18;
    private final AdvancedContainer invPattern = new AdvancedContainer(9).listener(this).phantom();
    private byte patternIndex;
    private boolean spawningTrain;
    @Nullable
    private RollingStock lastCart;

    public TrainDispenserBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DISPENSER.get(), blockPos, blockState);
        this.setContainerSize(18);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TrainDispenserBlockEntity blockEntity) {
        if (blockEntity.spawningTrain && blockEntity.timeSinceLastSpawn % 4 == 0) {
            blockEntity.spawnNextCart((ServerLevel)level);
        }
        ++blockEntity.timeSinceLastSpawn;
    }

    private boolean spawnNextCart(ServerLevel serverLevel) {
        ItemStack cartItem;
        ItemStack spawn = this.invPattern.getItem(this.patternIndex);
        if (spawn.isEmpty()) {
            this.resetSpawnSequence();
            return false;
        }
        Predicate<ItemStack> filter = itemStack -> TrainDispenserBlockEntity.testMinecart(spawn, itemStack);
        if (this.countItems(filter) == 0) {
            this.resetSpawnSequence();
            return false;
        }
        BlockPos offset = this.getBlockPos().offset(this.getFacing().getNormal());
        if (EntitySearcher.findMinecarts().at(offset).list((Level)serverLevel).isEmpty() && !(cartItem = this.extract(filter)).isEmpty()) {
            AbstractMinecart placedCart = MinecartUtil.placeCart(cartItem, serverLevel, offset);
            if (placedCart != null) {
                RollingStock extension = RollingStock.getOrThrow(placedCart);
                if (this.lastCart != null) {
                    extension.link(this.lastCart);
                }
                this.lastCart = extension;
                this.patternIndex = (byte)(this.patternIndex + 1);
                if (this.patternIndex >= this.invPattern.getContainerSize()) {
                    this.resetSpawnSequence();
                }
                return true;
            }
            this.insert(cartItem);
        }
        return false;
    }

    private void resetSpawnSequence() {
        this.patternIndex = 0;
        this.spawningTrain = false;
        this.timeSinceLastSpawn = 0;
        this.lastCart = null;
    }

    @Override
    protected void onPulse(ServerLevel serverLevel) {
        boolean empty = EntitySearcher.findMinecarts().at(this.getBlockPos().offset(this.getFacing().getNormal())).list((Level)serverLevel).isEmpty();
        if (!empty) {
            return;
        }
        if (!this.spawningTrain && this.canBuildTrain() && this.timeSinceLastSpawn > (Integer)RailcraftConfig.SERVER.cartDispenserDelay.get() * 20) {
            this.spawningTrain = true;
        }
    }

    private boolean canBuildTrain() {
        ContainerManifest pattern = ContainerManifest.create(this.invPattern);
        ContainerManifest buffer = ContainerManifest.create(this.container(), (Collection<ItemStackKey>)pattern.keySet());
        return pattern.values().stream().anyMatch(e -> buffer.count(e.key()) >= e.count());
    }

    public AdvancedContainer getInvPattern() {
        return this.invPattern;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("trainDispenserFilters", (Tag)this.invPattern.createTag(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.invPattern.fromTag(tag.getList("trainDispenserFilters", 10), provider);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new TrainDispenserMenu(id, inventory, this);
    }

    private static boolean testMinecart(ItemStack original, ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof MinecartItem || item instanceof MinecartFactory || item instanceof CartItem) {
            return original.is(item);
        }
        return false;
    }
}

