/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.ForceTrackBlockEntity;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public final class ForceTrackBlock
extends TrackBlock
implements EntityBlock {
    public static final EnumProperty<DyeColor> COLOR = ForceTrackEmitterBlock.COLOR;
    public static final EnumProperty<RailShape> SHAPE = EnumProperty.create((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.NORTH_SOUTH, RailShape.EAST_WEST});

    public ForceTrackBlock(BlockBehaviour.Properties properties) {
        super((Supplier<? extends TrackType>)TrackTypes.HIGH_SPEED, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue(COLOR, (Comparable)ForceTrackEmitterBlock.DEFAULT_COLOR);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{COLOR});
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public BlockState updateDir(Level level, BlockPos pos, BlockState state, boolean alwaysPlace) {
        return state;
    }

    @Override
    public boolean canMakeSlopes(BlockState blockState, BlockGetter world, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(BlockState blockState, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Override
    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        BlockEntity blockEntity;
        if (neighborBlock != this && (blockEntity = level.getBlockEntity(pos)) instanceof ForceTrackBlockEntity) {
            ForceTrackBlockEntity forceTrackBlockEntity = (ForceTrackBlockEntity)blockEntity;
            forceTrackBlockEntity.neighborChanged();
        }
    }

    @Override
    public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        if (!oldBlockState.is(blockState.getBlock())) {
            this.updateState(blockState, level, pos, moved);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK.get()).ifPresent(ForceTrackBlockEntity::blockRemoved);
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    @Override
    public float getRailMaxSpeed(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        return 0.6f;
    }

    @Override
    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ForceTrackBlockEntity(blockPos, blockState);
    }
}

