/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.actuator;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.client.ScreenFactories;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SwitchTrackMotorBlockEntity;
import mods.railcraft.world.level.block.track.actuator.SwitchTrackActuatorBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class SwitchTrackMotorBlock
extends SwitchTrackActuatorBlock
implements EntityBlock {
    public SwitchTrackMotorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborBlockPos, boolean moved) {
        level.getBlockEntity(blockPos, (BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_MOTOR.get()).ifPresent(SwitchTrackMotorBlockEntity::neighborChanged);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_MOTOR.get()).ifPresent(ScreenFactories::openSwitchTrackMotorScreen);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SwitchTrackMotorBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.SWITCH_TRACKS).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.AERIAL_LINKAGES).append(CommonComponents.SPACE).append((Component)Component.translatable((String)Translations.Tips.RECEIVERS, (Object[])new Object[]{1})).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.REDSTONE_LINKAGE).append(CommonComponents.SPACE).append((Component)Component.translatable((String)Translations.Tips.LISTEN)).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.RELEVANT_TOOLS).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)Translations.Tips.SIGNAL_TUNER)).withStyle(ChatFormatting.RED));
    }
}

