/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class DisembarkingTrackBlock
extends PoweredOutfittedTrackBlock {
    private static final int TIME_TILL_NEXT_MOUNT = 40;
    public static final BooleanProperty MIRRORED = BooleanProperty.create((String)"mirrored");

    public DisembarkingTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MIRRORED});
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return level.setBlockAndUpdate(pos, (BlockState)blockState.cycle((Property)MIRRORED));
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos blockPos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, blockPos, cart);
        if (DisembarkingTrackBlock.isPowered(blockState) && cart.isVehicle()) {
            double x = blockPos.getX();
            double z = blockPos.getZ();
            double offset = 1.0;
            RailShape railShape = DisembarkingTrackBlock.getRailShapeRaw(blockState);
            boolean mirrored = DisembarkingTrackBlock.isMirrored(blockState);
            if (railShape == RailShape.NORTH_SOUTH) {
                x = mirrored ? (x += offset) : (x -= offset);
            } else {
                z = mirrored ? (z += offset) : (z -= offset);
            }
            MinecartUtil.removePassengers(cart, x + 0.5, (double)blockPos.getY() + 1.0, z + 0.5);
            RollingStock.getOrThrow(cart).setPreventMountRemainingTicks(40);
        }
    }

    public static boolean isMirrored(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)MIRRORED);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.DISEMBARKING_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_DIRECTION).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).withStyle(ChatFormatting.RED));
    }
}

