/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.LockingTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.LockingMode;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LockingTrackBlock
extends PoweredOutfittedTrackBlock
implements EntityBlock {
    public static final Property<LockingMode> LOCKING_MODE = EnumProperty.create((String)"locking_mode", LockingMode.class);

    public LockingTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue(LOCKING_MODE, (Comparable)((Object)LockingMode.LOCKDOWN));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LOCKING_MODE});
    }

    @Override
    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        LockingMode mode = LockingTrackBlock.getLockingMode(state);
        LockingMode newMode = player.isCrouching() ? mode.previous() : mode.next();
        boolean res = level.setBlockAndUpdate(pos, (BlockState)state.setValue(LOCKING_MODE, (Comparable)((Object)newMode)));
        if (!level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()).ifPresent(lockingTrack -> lockingTrack.setLockingModeController(newMode.create((LockingTrackBlockEntity)lockingTrack)));
        }
        MutableComponent currentMode = Component.translatable((String)Translations.Tips.CURRENT_MODE);
        MutableComponent modeDisplay = newMode.getDisplayName().copy().withStyle(ChatFormatting.DARK_PURPLE);
        player.displayClientMessage((Component)currentMode.append(CommonComponents.SPACE).append((Component)modeDisplay), true);
        return res;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()).ifPresent(lockingTrack -> lockingTrack.minecartPassed(cart));
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new LockingTrackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()), LockingTrackBlockEntity::serverTick);
    }

    public static LockingMode getLockingMode(BlockState blockState) {
        return (LockingMode)((Object)blockState.getValue(LOCKING_MODE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.LOCKING_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_RELEASE_CARTS).withStyle(ChatFormatting.RED));
    }
}

