/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ThrottleTrackBlock
extends PoweredOutfittedTrackBlock {
    public static final Property<Locomotive.Speed> LOCOMOTIVE_SPEED = EnumProperty.create((String)"locomotive_speed", Locomotive.Speed.class);
    public static final BooleanProperty REVERSE = BooleanProperty.create((String)"reverse");

    public ThrottleTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)super.buildDefaultState(blockState).setValue(LOCOMOTIVE_SPEED, (Comparable)((Object)Locomotive.Speed.MAX))).setValue((Property)REVERSE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LOCOMOTIVE_SPEED, REVERSE});
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(state, level, pos, cart);
        if (ThrottleTrackBlock.isPowered(state)) {
            RollingStock.getOrThrow(cart).train().entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).forEach(locomotive -> {
                locomotive.setSpeed((Locomotive.Speed)((Object)((Object)state.getValue(LOCOMOTIVE_SPEED))));
                locomotive.setReverse((Boolean)state.getValue((Property)REVERSE));
            });
        }
    }

    @Override
    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        BlockState newState = (BlockState)state.cycle(LOCOMOTIVE_SPEED);
        Locomotive.Speed speed = (Locomotive.Speed)((Object)newState.getValue(LOCOMOTIVE_SPEED));
        if (speed.equals((Object)Locomotive.Speed.SLOWEST)) {
            newState = (BlockState)newState.cycle((Property)REVERSE);
        }
        return level.setBlockAndUpdate(pos, newState);
    }

    public static Locomotive.Speed getSpeedMode(BlockState blockState) {
        return (Locomotive.Speed)((Object)blockState.getValue(LOCOMOTIVE_SPEED));
    }

    public static boolean isReverse(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)REVERSE);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.THROTTLE_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).withStyle(ChatFormatting.RED));
    }
}

