/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.signal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.world.signal.SimpleTokenRing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TokenRingManager
extends SavedData {
    private static final String DATA_TAG = "railcraft.tokens";
    private final ServerLevel level;
    private final Map<UUID, SimpleTokenRing> tokenRings = new HashMap<UUID, SimpleTokenRing>();
    private int clock;

    public TokenRingManager(ServerLevel level) {
        this.level = level;
    }

    private void load(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag tokenRingList = tag.getList("tokenRings", 10);
        for (int i = 0; i < tokenRingList.size(); ++i) {
            CompoundTag entry = tokenRingList.getCompound(i);
            UUID id = entry.getUUID("id");
            SimpleTokenRing tokenRing = new SimpleTokenRing(this.level, this, id);
            this.tokenRings.put(id, tokenRing);
            ListTag signalList = entry.getList("signals", 10);
            Set<BlockPos> signalPositions = signalList.stream().map(CompoundTag.class::cast).map(x -> (BlockPos)NbtUtils.readBlockPos((CompoundTag)x, (String)"pos").orElseThrow()).collect(Collectors.toSet());
            tokenRing.loadSignals(signalPositions);
            ListTag cartList = entry.getList("carts", 10);
            Set<UUID> carts = cartList.stream().map(CompoundTag.class::cast).map(signal -> signal.getUUID("cart")).collect(Collectors.toSet());
            tokenRing.loadCarts(carts);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag tokenRingList = new ListTag();
        for (SimpleTokenRing tokenRing : this.tokenRings.values()) {
            CompoundTag tokenData = new CompoundTag();
            tokenData.putUUID("id", tokenRing.getId());
            ListTag signalList = new ListTag();
            for (BlockPos pos : tokenRing.peers()) {
                CompoundTag posTag = new CompoundTag();
                posTag.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
                signalList.add((Object)posTag);
            }
            tokenData.put("signals", (Tag)signalList);
            ListTag cartList = new ListTag();
            for (UUID uuid : tokenRing.getTrackedCarts()) {
                CompoundTag cart = new CompoundTag();
                cart.putUUID("cart", uuid);
                cartList.add((Object)cart);
            }
            tokenData.put("carts", (Tag)cartList);
            tokenRingList.add((Object)tokenData);
        }
        tag.put("tokenRings", (Tag)tokenRingList);
        return tag;
    }

    public void tick(ServerLevel level) {
        ++this.clock;
        if (this.clock >= 32) {
            this.clock = 0;
            if (this.tokenRings.entrySet().removeIf(e -> ((SimpleTokenRing)e.getValue()).isOrphaned(level))) {
                this.setDirty();
            }
            this.tokenRings.values().forEach(SimpleTokenRing::tick);
        }
    }

    public SimpleTokenRing getTokenRingNetwork(UUID id, BlockPos origin) {
        return this.tokenRings.computeIfAbsent(id, __ -> new SimpleTokenRing(this.level, this, id, origin));
    }

    public static TokenRingManager get(ServerLevel level) {
        return (TokenRingManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new TokenRingManager(level), (tag, provider) -> {
            TokenRingManager manager = new TokenRingManager(level);
            manager.load((CompoundTag)tag, (HolderLookup.Provider)provider);
            return manager;
        }), DATA_TAG);
    }
}

