/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.ContextSnapshot;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.part.CommandPart;

public class SimpleCommandContext
implements CommandContext,
Namespace {
    private Namespace namespace;
    private Command executedCommand;
    private List<Command> commandExecutionPath;
    private List<String> rawArguments;
    private List<String> labels;
    private Set<CommandPart> allParts;
    private Map<String, List<CommandPart>> allPartsByName;
    private Map<CommandPart, List<String>> rawBindings;
    private Map<CommandPart, List<Object>> valueBindings;

    public SimpleCommandContext(Namespace namespace, List<String> rawArguments) {
        this.namespace = namespace;
        this.rawBindings = new HashMap<CommandPart, List<String>>();
        this.allParts = new HashSet<CommandPart>();
        this.allPartsByName = new HashMap<String, List<CommandPart>>();
        this.valueBindings = new HashMap<CommandPart, List<Object>>();
        this.commandExecutionPath = new ArrayList<Command>();
        this.rawArguments = rawArguments;
        this.labels = new ArrayList<String>();
    }

    @Override
    public ContextSnapshot getSnapshot() {
        return new ContextSnapshot(this.namespace, this.executedCommand, new ArrayList<Command>(this.commandExecutionPath), new ArrayList<String>(this.rawArguments), new ArrayList<String>(this.labels), new HashSet<CommandPart>(this.allParts), new HashMap<String, List<CommandPart>>(this.allPartsByName), new HashMap<CommandPart, List<String>>(this.rawBindings), new HashMap<CommandPart, List<Object>>(this.valueBindings));
    }

    @Override
    public void applySnapshot(ContextSnapshot snapshot) {
        this.namespace = snapshot.namespace;
        this.executedCommand = snapshot.executedCommand;
        this.commandExecutionPath = snapshot.commandExecutionPath;
        this.rawArguments = snapshot.rawArguments;
        this.labels = snapshot.labels;
        this.allParts = snapshot.allParts;
        this.allPartsByName = snapshot.allPartsByName;
        this.rawBindings = snapshot.rawBindings;
        this.valueBindings = snapshot.valueBindings;
    }

    @Override
    public void setCommand(Command command, String label) {
        this.executedCommand = command;
        this.commandExecutionPath.add(command);
        this.labels.add(label);
    }

    @Override
    public void removeLastCommand() {
        this.commandExecutionPath.remove(this.executedCommand);
        this.executedCommand = this.commandExecutionPath.get(this.commandExecutionPath.size() - 1);
        this.labels.remove(this.labels.size() - 1);
    }

    @Override
    public Command getCommand() {
        return this.executedCommand;
    }

    @Override
    public List<Command> getExecutionPath() {
        return this.commandExecutionPath;
    }

    @Override
    public List<String> getArguments() {
        return this.rawArguments;
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public List<CommandPart> getParts(String name) {
        return this.allPartsByName.computeIfAbsent(name, k -> new ArrayList());
    }

    @Override
    public boolean contains(CommandPart part) {
        return this.allParts.contains(part);
    }

    @Override
    public List<String> getRaw(CommandPart part) {
        return this.rawBindings.get(part);
    }

    @Override
    public <V> List<V> getValues(CommandPart part) {
        return this.valueBindings.get(part);
    }

    private void addPart(CommandPart part) {
        this.allParts.add(part);
        List parts = this.allPartsByName.computeIfAbsent(part.getName(), key -> new ArrayList());
        if (!parts.contains(part)) {
            parts.add(part);
        }
    }

    @Override
    public boolean hasValue(CommandPart part) {
        return this.valueBindings.containsKey(part);
    }

    @Override
    public <T> void setValue(CommandPart part, T value) {
        this.addPart(part);
        this.valueBindings.computeIfAbsent(part, commandPart -> new ArrayList()).add(value);
    }

    @Override
    public <T> void setValues(CommandPart part, List<T> values) {
        this.addPart(part);
        this.valueBindings.computeIfAbsent(part, commandPart -> new ArrayList()).addAll(values);
    }

    @Override
    public void setRaw(CommandPart part, List<String> raw) {
        this.addPart(part);
        this.rawBindings.put(part, raw);
    }

    @Override
    public <T> T getObject(Class<T> clazz, String name) {
        return this.namespace.getObject(clazz, name);
    }

    @Override
    public <T> void setObject(Class<T> clazz, String name, T object) {
        this.namespace.setObject(clazz, name, object);
    }
}

