/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.fixeddev.commandflow.Authorizer;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.CommandManager;
import me.fixeddev.commandflow.ErrorHandler;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.ParseResult;
import me.fixeddev.commandflow.SimpleCommandContext;
import me.fixeddev.commandflow.SimpleErrorHandler;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.command.modifiers.CommandModifiers;
import me.fixeddev.commandflow.command.modifiers.FallbackCommandModifiers;
import me.fixeddev.commandflow.command.modifiers.ModifierPhase;
import me.fixeddev.commandflow.exception.ArgumentException;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.CommandException;
import me.fixeddev.commandflow.exception.CommandUsage;
import me.fixeddev.commandflow.exception.NoPermissionsException;
import me.fixeddev.commandflow.exception.StopParseException;
import me.fixeddev.commandflow.executor.DefaultExecutor;
import me.fixeddev.commandflow.executor.Executor;
import me.fixeddev.commandflow.input.InputTokenizer;
import me.fixeddev.commandflow.input.StringSpaceTokenizer;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.SimpleArgumentStack;
import me.fixeddev.commandflow.translator.DefaultMapTranslationProvider;
import me.fixeddev.commandflow.translator.DefaultTranslator;
import me.fixeddev.commandflow.translator.Translator;
import me.fixeddev.commandflow.usage.DefaultUsageBuilder;
import me.fixeddev.commandflow.usage.UsageBuilder;

public class SimpleCommandManager
implements CommandManager {
    private final Map<String, Command> commandMap;
    private Authorizer authorizer;
    private InputTokenizer tokenizer;
    private Executor executor;
    private Translator translator;
    private UsageBuilder usageBuilder;
    private ErrorHandler errorHandler;
    private final FallbackCommandModifiers fallbackCommandModifiers;

    public SimpleCommandManager(Authorizer authorizer) {
        this.authorizer = authorizer;
        this.commandMap = new HashMap<String, Command>();
        this.tokenizer = new StringSpaceTokenizer();
        this.executor = new DefaultExecutor();
        this.translator = new DefaultTranslator(new DefaultMapTranslationProvider());
        this.usageBuilder = new DefaultUsageBuilder();
        this.fallbackCommandModifiers = new FallbackCommandModifiers();
        this.errorHandler = new SimpleErrorHandler();
        this.errorHandler.addExceptionHandler(StopParseException.class, (namespace, throwable) -> true);
    }

    public SimpleCommandManager() {
        this((namespace, permission) -> true);
    }

    @Override
    public void registerCommand(Command command) {
        if (this.commandMap.containsKey(command.getName())) {
            throw new IllegalArgumentException("A command with the name " + command.getName() + " is already registered!");
        }
        this.commandMap.put(command.getName().toLowerCase(), command);
        command.getAliases().forEach(alias -> this.commandMap.putIfAbsent(alias.toLowerCase(), command));
    }

    @Override
    public void registerCommand(String label, Command command) {
        this.commandMap.putIfAbsent(label.toLowerCase(), command);
    }

    @Override
    public void registerCommands(List<Command> commandList) {
        for (Command command : commandList) {
            this.registerCommand(command);
        }
    }

    @Override
    public void unregisterCommand(Command command) {
        this.commandMap.remove(command.getName());
        for (String alias : command.getAliases()) {
            this.commandMap.remove(alias);
        }
    }

    @Override
    public void unregisterCommands(List<Command> commands) {
        for (Command command : commands) {
            this.unregisterCommand(command);
        }
    }

    @Override
    public void unregisterAll() {
        HashSet<Command> commands = new HashSet<Command>(this.commandMap.values());
        for (Command command : commands) {
            this.unregisterCommand(command);
        }
    }

    @Override
    public Set<Command> getCommands() {
        return new HashSet<Command>(this.commandMap.values());
    }

    @Override
    public boolean exists(String commandName) {
        return this.commandMap.containsKey(commandName);
    }

    @Override
    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    @Override
    public void setAuthorizer(Authorizer authorizer) {
        if (authorizer == null) {
            throw new IllegalArgumentException("Trying to set a null authorizer!");
        }
        this.authorizer = authorizer;
    }

    @Override
    public InputTokenizer getInputTokenizer() {
        return this.tokenizer;
    }

    @Override
    public void setInputTokenizer(InputTokenizer tokenizer) {
        if (tokenizer == null) {
            throw new IllegalArgumentException("Trying to set a null input tokenizer!");
        }
        this.tokenizer = tokenizer;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Trying to set a null Executor!");
        }
        this.executor = executor;
    }

    @Override
    public Translator getTranslator() {
        return this.translator;
    }

    @Override
    public void setTranslator(Translator translator) {
        if (translator == null) {
            throw new IllegalArgumentException("Trying to set a null Translator!");
        }
        this.translator = translator;
    }

    @Override
    public UsageBuilder getUsageBuilder() {
        return this.usageBuilder;
    }

    @Override
    public void setUsageBuilder(UsageBuilder usageBuilder) {
        if (usageBuilder == null) {
            throw new IllegalArgumentException("Trying to set a null UsageBuilder!");
        }
        this.usageBuilder = usageBuilder;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.errorHandler == null) {
            throw new IllegalArgumentException("Trying to set a null ErrorHandler!");
        }
        this.errorHandler = errorHandler;
    }

    @Override
    public FallbackCommandModifiers getCommandModifiers() {
        return this.fallbackCommandModifiers;
    }

    @Override
    public Optional<Command> getCommand(String commandName) {
        return Optional.ofNullable(this.commandMap.get(commandName.toLowerCase()));
    }

    @Override
    public boolean execute(CommandContext commandContext) throws CommandException {
        if (commandContext == null) {
            throw new IllegalArgumentException("The CommandContext can't be null!");
        }
        return this.executor.execute(commandContext, this.getUsageBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Namespace accessor, List<String> arguments) throws CommandException {
        ParseResult result = this.parse(accessor, arguments);
        Optional<CommandException> optionalException = result.getException();
        Optional<CommandContext> optionalContext = result.getContext();
        if (optionalException.isPresent()) {
            CommandException exception = optionalException.get();
            if (exception instanceof ArgumentException && !(exception instanceof ArgumentParseException)) {
                CommandContext commandContext = optionalContext.get();
                ArgumentException e = (ArgumentException)exception;
                exception = new CommandUsage(this.usageBuilder.getUsage(commandContext)).setCommand(commandContext.getCommand());
                exception.initCause(e);
            }
            try {
                return this.errorHandler.handleException(accessor, exception);
            }
            catch (Throwable ex) {
                this.throwOrWrap(ex);
            }
        }
        if (!optionalContext.isPresent()) {
            return false;
        }
        CommandContext commandContext = optionalContext.get();
        CommandModifiers modifiers = commandContext.getCommand().getModifiers();
        if (!modifiers.hasModifiers(ModifierPhase.PRE_EXECUTE) ? !this.fallbackCommandModifiers.callModifiers(ModifierPhase.PRE_EXECUTE, commandContext, null) : !modifiers.callModifiers(ModifierPhase.PRE_EXECUTE, commandContext, null)) {
            return false;
        }
        try {
            boolean e = this.executor.execute(commandContext, this.getUsageBuilder());
            return e;
        }
        catch (Throwable e) {
            try {
                boolean bl = this.errorHandler.handleException(accessor, e);
                return bl;
            }
            catch (Throwable ex) {
                this.throwOrWrap(ex);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (!modifiers.hasModifiers(ModifierPhase.POST_EXECUTE)) {
                this.fallbackCommandModifiers.callModifiers(ModifierPhase.POST_EXECUTE, commandContext, null);
            } else {
                commandContext.getCommand().getModifiers().callModifiers(ModifierPhase.POST_EXECUTE, commandContext, null);
            }
        }
    }

    @Override
    public boolean execute(Namespace accessor, String line) throws CommandException {
        return this.execute(accessor, this.tokenizer.tokenize(line));
    }

    @Override
    public List<String> getSuggestions(Namespace accessor, List<String> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Command> optionalCommand = this.getCommand(arguments.get(0));
        if (!optionalCommand.isPresent()) {
            return Collections.emptyList();
        }
        arguments.remove(0);
        Command command = optionalCommand.get();
        if (!this.authorizer.isAuthorized(accessor, command.getPermission())) {
            return Collections.emptyList();
        }
        SimpleCommandContext commandContext = new SimpleCommandContext(accessor, arguments);
        commandContext.setCommand(command, command.getName());
        accessor.setObject(CommandManager.class, "commandManager", this);
        SimpleArgumentStack stack = new SimpleArgumentStack(arguments);
        return command.getPart().getSuggestions(commandContext, stack);
    }

    @Override
    public List<String> getSuggestions(Namespace accessor, String line) {
        return this.getSuggestions(accessor, this.tokenizer.tokenize(line));
    }

    @Override
    public ParseResult parse(Namespace accessor, String line) {
        return this.parse(accessor, this.tokenizer.tokenize(line));
    }

    @Override
    public ParseResult parse(Namespace accessor, List<String> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return this.empty();
        }
        Optional<Command> optionalCommand = this.getCommand(arguments.get(0));
        if (!optionalCommand.isPresent()) {
            return this.empty();
        }
        accessor.setObject(CommandManager.class, "commandManager", this);
        SimpleArgumentStack stack = new SimpleArgumentStack(arguments);
        String label = stack.next();
        Command command = optionalCommand.get();
        if (!this.authorizer.isAuthorized(accessor, command.getPermission())) {
            NoPermissionsException exception = new NoPermissionsException(command.getPermissionMessage());
            exception.setCommand(command);
            return this.ofError(exception);
        }
        SimpleCommandContext commandContext = new SimpleCommandContext(accessor, arguments);
        commandContext.setCommand(command, label);
        CommandModifiers modifiers = command.getModifiers();
        if (!modifiers.hasModifiers(ModifierPhase.PRE_PARSE) ? !this.fallbackCommandModifiers.callModifiers(ModifierPhase.PRE_PARSE, commandContext, stack) : !modifiers.callModifiers(ModifierPhase.PRE_PARSE, commandContext, stack)) {
            return new ParseResultImpl();
        }
        CommandPart part = command.getPart();
        try {
            part.parse(commandContext, stack, null);
        }
        catch (ArgumentParseException e) {
            return this.ofError(commandContext, e);
        }
        catch (ArgumentException e) {
            CommandUsage usage = new CommandUsage(this.usageBuilder.getUsage(commandContext));
            usage.setCommand(commandContext.getCommand());
            usage.initCause(e);
            return this.ofError(commandContext, e);
        }
        catch (CommandException e) {
            return this.ofError(commandContext, e);
        }
        return this.ofSuccess(commandContext);
    }

    private void throwOrWrap(Throwable throwable) throws CommandException {
        if (throwable instanceof CommandException) {
            throw (CommandException)throwable;
        }
        throw new CommandException(throwable);
    }

    private ParseResult empty() {
        return new ParseResultImpl();
    }

    private ParseResult ofSuccess(CommandContext commandContext) {
        return new ParseResultImpl(commandContext);
    }

    private ParseResult ofError(CommandException exception) {
        return new ParseResultImpl(exception);
    }

    private ParseResult ofError(CommandContext commandContext, CommandException exception) {
        return new ParseResultImpl(commandContext, exception);
    }

    protected static class ParseResultImpl
    implements ParseResult {
        private CommandContext commandContext;
        private CommandException exception;

        public ParseResultImpl(CommandContext commandContext, CommandException exception) {
            this.commandContext = commandContext;
            this.exception = exception;
        }

        public ParseResultImpl(CommandContext commandContext) {
            this.commandContext = commandContext;
        }

        public ParseResultImpl(CommandException exception) {
            this.exception = exception;
        }

        public ParseResultImpl() {
        }

        @Override
        public Optional<CommandContext> getContext() {
            return Optional.ofNullable(this.commandContext);
        }

        @Override
        public Optional<CommandException> getException() {
            return Optional.ofNullable(this.exception);
        }
    }
}

