/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.fixeddev.commandflow.ErrorHandler;
import me.fixeddev.commandflow.Namespace;

public class SimpleErrorHandler
implements ErrorHandler {
    private final Map<Class<?>, ErrorHandler.ErrorConsumer<?>> exceptionHandlers = new HashMap();
    private ErrorHandler.ErrorConsumer<Throwable> defaultHandler = THROW_CONSUMER;

    @Override
    public <T extends Throwable> void addExceptionHandler(Class<? extends T> type, ErrorHandler.ErrorConsumer<T> consumer) {
        Objects.requireNonNull(consumer, "The error handler can't be null");
        this.exceptionHandlers.put(type, consumer);
    }

    @Override
    public void setFallbackHandler(ErrorHandler.ErrorConsumer<Throwable> consumer) {
        this.defaultHandler = Objects.requireNonNull(consumer, "The fallback error handler can't be null");
    }

    @Override
    public boolean handleException(Namespace namespace, Throwable exception) throws Throwable {
        Class<?> throwableType = exception.getClass();
        ErrorHandler.ErrorConsumer<Throwable> consumer = this.exceptionHandlers.getOrDefault(throwableType, this.defaultHandler);
        return consumer.accept(namespace, exception);
    }
}

