/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.fixeddev.commandflow.annotated.CommandClass;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.exception.ArgumentException;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.defaults.SubCommandPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionSubCommandHandler
implements SubCommandPart.SubCommandHandler {
    private final CommandClass handler;
    private final Method handlerMethod;

    public ReflectionSubCommandHandler(CommandClass handler, Method handlerMethod) {
        this.handler = handler;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public void handle( @NotNull SubCommandPart.HandlerContext context, @NotNull String label, @Nullable Command command) throws ArgumentParseException {
        try {
            boolean accessible = this.handlerMethod.isAccessible();
            this.handlerMethod.setAccessible(true);
            this.handlerMethod.invoke((Object)this.handler, context, label, command);
            this.handlerMethod.setAccessible(accessible);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ArgumentException) {
                throw (ArgumentException)cause;
            }
            throw new ArgumentParseException("Internal error.", cause).setArgument(context.getPart()).setCommand(context.getContext().getCommand());
        }
    }
}

