/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.annotated.CommandClass;
import me.fixeddev.commandflow.annotated.action.ValueGetter;
import me.fixeddev.commandflow.command.Action;
import me.fixeddev.commandflow.exception.CommandException;

public class ReflectiveAction
implements Action {
    private final List<ValueGetter> getterList;
    private final CommandClass handler;
    private final Method handlerMethod;

    public ReflectiveAction(List<ValueGetter> getterList, CommandClass handler, Method handlerMethod) {
        this.getterList = getterList;
        this.handler = handler;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public boolean execute(CommandContext context) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (ValueGetter valueGetter : this.getterList) {
            values.add(valueGetter.getValue(context));
        }
        try {
            boolean accessible = this.handlerMethod.isAccessible();
            this.handlerMethod.setAccessible(true);
            Object value = this.handlerMethod.invoke((Object)this.handler, values.toArray());
            this.handlerMethod.setAccessible(accessible);
            if (value == null) {
                return true;
            }
            return (Boolean)value;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable throwableToThrow = e;
            if (e.getCause() != null) {
                throwableToThrow = e.getCause();
            }
            if (throwableToThrow instanceof CommandException) {
                throw (CommandException)throwableToThrow;
            }
            throw new CommandException("Internal error.", throwableToThrow);
        }
    }
}

