/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated.part;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.fixeddev.commandflow.annotated.part.DelegatePartModifier;
import me.fixeddev.commandflow.annotated.part.Key;
import me.fixeddev.commandflow.annotated.part.Module;
import me.fixeddev.commandflow.annotated.part.PartFactory;
import me.fixeddev.commandflow.annotated.part.PartModifier;
import me.fixeddev.commandflow.annotated.part.SimplePartInjector;
import me.fixeddev.commandflow.part.CommandPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PartInjector {
    @Nullable
    default public PartFactory getFactory(Type type) {
        return this.getFactory(new Key(type));
    }

    @Nullable
    public PartFactory getFactory(Key var1);

    @Nullable
    public PartModifier getModifier(Class<? extends Annotation> var1);

    @NotNull
    default public PartModifier getModifiers(List<Class<? extends Annotation>> annotations) {
        ArrayList<PartModifier> modifiers = new ArrayList<PartModifier>();
        for (Class<? extends Annotation> annotation : annotations) {
            PartModifier modifier = this.getModifier(annotation);
            if (modifier == null) continue;
            modifiers.add(modifier);
        }
        return new DelegatePartModifier(modifiers);
    }

    @NotNull
    default public PartModifier getModifiers(Class<? extends Annotation> ... annotations) {
        return this.getModifiers(Arrays.asList(annotations));
    }

    public void bindModifier(Class<? extends Annotation> var1, PartModifier var2);

    default public void bindFactory(Type type, PartFactory partFactory) {
        this.bindFactory(new Key(type), partFactory);
    }

    public void bindFactory(Key var1, PartFactory var2);

    default public void bindPart(Type type, CommandPart part) {
        this.bindPart(new Key(type), part);
    }

    default public void bindPart(Key key, CommandPart part) {
        this.bindFactory(key, (String name, List<? extends Annotation> modifiers) -> part);
    }

    public void install(Module var1);

    public static PartInjector create() {
        return new SimplePartInjector();
    }
}

