/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated.part;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.fixeddev.commandflow.annotated.part.Key;
import me.fixeddev.commandflow.annotated.part.Module;
import me.fixeddev.commandflow.annotated.part.PartFactory;
import me.fixeddev.commandflow.annotated.part.PartInjector;
import me.fixeddev.commandflow.annotated.part.PartModifier;
import org.jetbrains.annotations.Nullable;

public class SimplePartInjector
implements PartInjector {
    private final Map<Key, PartFactory> factoryBindings = new ConcurrentHashMap<Key, PartFactory>();
    private final Map<Class<? extends Annotation>, PartModifier> modifiers = new ConcurrentHashMap<Class<? extends Annotation>, PartModifier>();

    @Override
    @Nullable
    public PartFactory getFactory(Key key) {
        return this.factoryBindings.get(key);
    }

    @Override
    @Nullable
    public PartModifier getModifier(Class<? extends Annotation> annotation) {
        return this.modifiers.get(annotation);
    }

    @Override
    public void bindModifier(Class<? extends Annotation> annotation, PartModifier partModifier) {
        PartModifier old = this.modifiers.put(annotation, partModifier);
        if (old != null) {
            this.modifiers.put(annotation, old);
            throw new IllegalArgumentException("A modifier with the key " + annotation.toString() + " is already present!");
        }
    }

    @Override
    public void bindFactory(Key key, PartFactory factory) {
        PartFactory old = this.factoryBindings.put(key, factory);
        if (old != null) {
            this.factoryBindings.put(key, old);
            throw new IllegalArgumentException("A factory with the key " + key.toString() + " is already present!");
        }
    }

    @Override
    public void install(Module module) {
        module.configure(this);
    }
}

