/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit.part;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.bukkit.part.OfflinePlayerPart;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.ArgumentPart;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerPart
implements ArgumentPart {
    private final String name;
    private final boolean exact;
    private final boolean orSource;

    public PlayerPart(String name, boolean exact, boolean orSource) {
        this.name = name;
        this.exact = exact;
        this.orSource = orSource;
    }

    public List<Player> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        Player player;
        block7: {
            if (!stack.hasNext()) {
                player = this.tryGetSender(context);
                if (this.orSource && player != null) {
                    return Collections.singletonList(player);
                }
            }
            String target = stack.next();
            try {
                UUID uuid = UUID.fromString(target);
                player = Bukkit.getPlayer((UUID)uuid);
            }
            catch (IllegalArgumentException ex) {
                player = this.exact ? Bukkit.getPlayerExact((String)target) : Bukkit.getPlayer((String)target);
                if (player != null) break block7;
                player = this.tryGetSender(context);
                if (this.orSource && player != null) {
                    return Collections.singletonList(player);
                }
                throw new ArgumentParseException(TranslatableComponent.of("player.offline", TextComponent.of(target))).setArgument(this);
            }
        }
        if (player == null) {
            player = this.tryGetSender(context);
            if (this.orSource && player != null) {
                return Collections.singletonList(player);
            }
        }
        return Collections.singletonList(player);
    }

    private Player tryGetSender(CommandContext context) {
        CommandSender sender = context.getObject(CommandSender.class, "SENDER");
        if (sender instanceof Player) {
            return (Player)sender;
        }
        return null;
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        return OfflinePlayerPart.getStrings(stack);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerPart)) {
            return false;
        }
        PlayerPart that = (PlayerPart)o;
        return this.exact == that.exact && this.orSource == that.orSource && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.exact, this.orSource);
    }
}

