/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit.part;

import java.util.Objects;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.CommandException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TranslatableComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerSenderPart
implements CommandPart {
    private final String name;

    public PlayerSenderPart(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        CommandSender sender = context.getObject(CommandSender.class, "SENDER");
        if (sender != null) {
            if (sender instanceof Player) {
                context.setValue(this, sender);
                return;
            }
            throw new ArgumentParseException(TranslatableComponent.of("sender.only-player"));
        }
        throw new CommandException(TranslatableComponent.of("sender.unknown"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerSenderPart)) {
            return false;
        }
        PlayerSenderPart that = (PlayerSenderPart)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

