/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.ArgumentPart;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WorldPart
implements ArgumentPart {
    private final String name;

    public WorldPart(String name) {
        this.name = name;
    }

    public List<World> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        return Collections.singletonList(this.checkedWorld(stack));
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        String prefix;
        String string = prefix = stack.hasNext() ? stack.next() : null;
        if (prefix == null) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().startsWith(prefix)) continue;
            suggestions.add(world.getName());
        }
        if (suggestions.size() == 1 && Bukkit.getWorld((String)((String)suggestions.get(0))) != null) {
            return Collections.emptyList();
        }
        return suggestions;
    }

    private World checkedWorld(ArgumentStack stack) {
        World world = Bukkit.getWorld((String)stack.next());
        if (world == null) {
            throw new ArgumentParseException("World not exist!");
        }
        return world;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

