/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.fixeddev.commandflow.command.Action;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.command.modifiers.CommandModifiers;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.Parts;
import me.fixeddev.commandflow.part.defaults.EmptyPart;
import net.kyori.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCommand
implements Command {
    private final String name;
    private final List<String> aliases;
    private final Component description;
    private final Component usage;
    private final String permission;
    private final Component permissionMessage;
    private final CommandPart mainPart;
    private final CommandModifiers modifiers;
    private final Action action;

    public SimpleCommand(String name, List<String> aliases, Component description, Component usage, String permission, Component permissionMessage, CommandPart mainPart, CommandModifiers modifiers, Action action) {
        this.name = name;
        this.aliases = aliases;
        this.description = description;
        this.usage = usage;
        this.permission = permission;
        this.permissionMessage = permissionMessage;
        this.mainPart = mainPart;
        this.modifiers = modifiers;
        this.action = action;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public Component getUsage() {
        return this.usage;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public Component getPermissionMessage() {
        return this.permissionMessage;
    }

    @Override
    @NotNull
    public CommandPart getPart() {
        return this.mainPart;
    }

    @Override
    @NotNull
    public CommandModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    @NotNull
    public Action getAction() {
        return this.action;
    }

    public static class Builder
    implements Command.Builder {
        private final String name;
        private List<String> aliases;
        private Component description;
        private Component usage;
        private String permission;
        private Component permissionMessage;
        private final List<CommandPart> parts;
        private CommandModifiers modifiers;
        private Action action;

        public Builder(String name) {
            this.name = name;
            this.aliases = new ArrayList<String>();
            this.parts = new ArrayList<CommandPart>();
            this.action = Action.NULL_ACTION;
        }

        @Override
        public Builder aliases(List<String> aliases) {
            if (aliases == null) {
                throw new IllegalArgumentException("The aliases shouldn't be a null list!");
            }
            this.aliases = aliases;
            return this;
        }

        @Override
        public Builder addAlias(String alias) {
            if (this.aliases.contains(alias)) {
                return this;
            }
            this.aliases.add(alias);
            return this;
        }

        @Override
        public Builder description(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("The description shouldn't be a null!");
            }
            this.description = component;
            return this;
        }

        @Override
        public Command.Builder usage(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("The usage shouldn't be a null!");
            }
            this.usage = component;
            return this;
        }

        @Override
        public Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public Builder permissionMessage(Component permissionMessage) {
            if (permissionMessage == null) {
                throw new IllegalArgumentException("The permissionMessage shouldn't be a null!");
            }
            this.permissionMessage = permissionMessage;
            return this;
        }

        @Override
        public Builder part(CommandPart part) {
            if (part == null) {
                throw new IllegalArgumentException("The CommandPart shouldn't be a null!");
            }
            this.parts.clear();
            this.parts.add(part);
            return this;
        }

        @Override
        public Builder addParts(CommandPart ... parts) {
            List<CommandPart> newParts = Arrays.asList(parts);
            this.parts.addAll(newParts);
            return this;
        }

        @Override
        public Builder addPart(CommandPart part) {
            this.parts.add(part);
            return this;
        }

        @Override
        public Command.Builder modifiers(CommandModifiers modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        @Override
        public Builder action(Action action) {
            if (action == null) {
                throw new IllegalArgumentException("The Action shouldn't be a null!");
            }
            this.action = action;
            return this;
        }

        @Override
        public Command build() {
            CommandPart part = new EmptyPart("empty-" + this.name);
            if (!this.parts.isEmpty()) {
                part = this.parts.size() == 1 ? this.parts.get(0) : Parts.sequential("sequential", this.parts);
            }
            if (this.permission == null) {
                this.permission = "";
            }
            if (this.modifiers == null) {
                this.modifiers = CommandModifiers.EMPTY;
            }
            return new SimpleCommand(this.name, this.aliases, this.description, this.usage, this.permission, this.permissionMessage, part, this.modifiers, this.action);
        }
    }
}

