/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.command.modifiers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.command.modifiers.CommandModifier;
import me.fixeddev.commandflow.command.modifiers.CommandModifiers;
import me.fixeddev.commandflow.command.modifiers.ModifierPhase;
import me.fixeddev.commandflow.command.modifiers.ModifierUtils;
import me.fixeddev.commandflow.command.modifiers.SequentialCommandModifier;
import me.fixeddev.commandflow.stack.ArgumentStack;

public class SimpleCommandModifiers
implements CommandModifiers {
    protected final Map<ModifierPhase, CommandModifier> modifiersByPhase;

    protected SimpleCommandModifiers(Map<ModifierPhase, CommandModifier> modifiersByPhase) {
        this.modifiersByPhase = modifiersByPhase;
        Iterator<ModifierPhase> phasesIterator = modifiersByPhase.keySet().iterator();
        while (phasesIterator.hasNext()) {
            ModifierPhase phase = phasesIterator.next();
            CommandModifier value = modifiersByPhase.get((Object)phase);
            if (!(value instanceof SequentialCommandModifier) || ((SequentialCommandModifier)value).hasModifiers()) continue;
            phasesIterator.remove();
        }
    }

    @Override
    public boolean callModifiers(ModifierPhase phase, CommandContext context, ArgumentStack stack) {
        if (!this.hasModifiers(phase)) {
            return true;
        }
        return this.modifiersByPhase.get((Object)phase).modify(context, stack, phase);
    }

    @Override
    public boolean hasModifiers(ModifierPhase phase) {
        CommandModifier modifier = this.modifiersByPhase.get((Object)phase);
        if (modifier == null) {
            return false;
        }
        if (modifier instanceof SequentialCommandModifier) {
            return ((SequentialCommandModifier)modifier).hasModifiers();
        }
        return true;
    }

    protected static class Builder
    implements CommandModifiers.Builder {
        private final Map<ModifierPhase, CommandModifier> modifiersByPhase = new HashMap<ModifierPhase, CommandModifier>(3);

        Builder() {
            this.modifiersByPhase.put(ModifierPhase.PRE_PARSE, new SequentialCommandModifier(new LinkedList<CommandModifier>()));
            this.modifiersByPhase.put(ModifierPhase.PRE_EXECUTE, new SequentialCommandModifier(new LinkedList<CommandModifier>()));
            this.modifiersByPhase.put(ModifierPhase.POST_EXECUTE, new SequentialCommandModifier(new LinkedList<CommandModifier>()));
        }

        @Override
        public void addModifier(CommandModifier modifier, ModifierPhase phase) {
            this.getSequential(phase).addModifier(modifier);
        }

        @Override
        public void addModifier(CommandModifier modifier, ModifierPhase phase, int idx) {
            this.getSequential(phase).addModifier(idx, modifier);
        }

        @Override
        public void removeModifier(CommandModifier modifier, ModifierPhase phase) {
            ModifierUtils.removeModifier(modifier, phase, this.modifiersByPhase);
        }

        @Override
        public void removeModifier(int idx, ModifierPhase phase) {
            CommandModifier phaseModifier = this.modifiersByPhase.get((Object)phase);
            if (phaseModifier instanceof SequentialCommandModifier) {
                SequentialCommandModifier seqModifier = (SequentialCommandModifier)phaseModifier;
                seqModifier.removeModifier(idx);
            }
        }

        @Override
        public void setModifier(CommandModifier modifier, ModifierPhase phase) {
            this.modifiersByPhase.put(phase, modifier);
        }

        @Override
        public CommandModifiers build() {
            return new SimpleCommandModifiers(this.modifiersByPhase);
        }

        private SequentialCommandModifier getSequential(ModifierPhase phase) {
            return ModifierUtils.getSequential(phase, this.modifiersByPhase);
        }
    }
}

