/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class EnumPart
extends PrimitivePart {
    private final Map<String, Object> enumConstants;
    private final String joinedEnumConstants;
    private final Class<?> enumClass;

    public EnumPart(String name, String joinDelimiter, Class<? extends Enum<?>> enumClass) {
        super(name);
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Given 'enumClass' isn't an enum type!");
        }
        this.enumClass = enumClass;
        this.enumConstants = new HashMap<String, Object>();
        Enum<?>[] enumArray = enumClass.getEnumConstants();
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> enumConstant;
            Enum<?> enumValue = enumConstant = enumArray[i];
            this.enumConstants.put(enumValue.name().toLowerCase(), enumValue);
        }
        this.joinedEnumConstants = String.join((CharSequence)joinDelimiter, this.enumConstants.keySet());
    }

    public EnumPart(String name, Class<? extends Enum<?>> enumClass) {
        this(name, ", ", enumClass);
    }

    @Override
    public List<?> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        String name = stack.next().toLowerCase();
        Object value = this.enumConstants.get(name);
        if (value == null) {
            TranslatableComponent message = TranslatableComponent.of("invalid.enum-value", TextComponent.of(name), TextComponent.of(this.joinedEnumConstants));
            throw new ArgumentParseException(message).setCommand(context.getCommand()).setArgument(this);
        }
        return Collections.singletonList(value);
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!stack.hasNext()) {
            return Collections.emptyList();
        }
        String prefix = stack.next().toLowerCase();
        for (String name : this.enumConstants.keySet()) {
            if (!name.startsWith(prefix)) continue;
            suggestions.add(name);
        }
        return suggestions;
    }
}

