/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.ContextSnapshot;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.CommandException;
import me.fixeddev.commandflow.exception.NoMoreArgumentsException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.PartsWrapper;
import me.fixeddev.commandflow.part.SinglePartWrapper;
import me.fixeddev.commandflow.stack.ArgumentStack;
import me.fixeddev.commandflow.stack.SimpleArgumentStack;
import me.fixeddev.commandflow.stack.StackSnapshot;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public class OptionalPart
implements CommandPart,
SinglePartWrapper {
    private final CommandPart part;
    private final List<String> defaultValues;
    private final boolean considerInvalidAsEmpty;

    public OptionalPart(CommandPart part) {
        this(part, true);
    }

    public OptionalPart(CommandPart part, boolean considerInvalidAsEmpty) {
        this(part, considerInvalidAsEmpty, new ArrayList<String>());
    }

    public OptionalPart(CommandPart part, List<String> defaultValues) {
        this(part, false, defaultValues);
    }

    public OptionalPart(CommandPart part, boolean considerInvalidAsEmpty, List<String> defaultValues) {
        this.part = part;
        this.defaultValues = defaultValues;
        this.considerInvalidAsEmpty = considerInvalidAsEmpty;
    }

    @Override
    public String getName() {
        return this.part.getName() + "-optional";
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        Component partLineRepresent = this.part.getLineRepresentation();
        if (partLineRepresent == null) {
            return null;
        }
        return ((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("[").append(partLineRepresent)).append(TextComponent.of("]"))).build();
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        block5: {
            StackSnapshot snapshot = stack.getSnapshot();
            ContextSnapshot contextSnapshot = context.getSnapshot();
            try {
                this.part.parse(context, stack, caller);
            }
            catch (ArgumentParseException | NoMoreArgumentsException e) {
                if (this.shouldRewind(caller, e)) {
                    throw e;
                }
                stack.applySnapshot(snapshot);
                context.applySnapshot(contextSnapshot);
                if (this.defaultValues.isEmpty()) break block5;
                try {
                    this.part.parse(context, new SimpleArgumentStack(this.defaultValues), this);
                }
                catch (ArgumentParseException | NoMoreArgumentsException argumentException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean shouldRewind(CommandPart caller, CommandException e) {
        boolean isLast = true;
        if (caller instanceof PartsWrapper) {
            List<CommandPart> parts = ((PartsWrapper)caller).getParts();
            isLast = parts.indexOf(this) == parts.size() - 1;
        }
        return isLast && !(e instanceof NoMoreArgumentsException) && !this.considerInvalidAsEmpty;
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        return Collections.emptyList();
    }

    @Override
    public boolean isAsync() {
        return this.part.isAsync();
    }

    @Override
    public CommandPart getPart() {
        return this.part;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }
}

