/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.stack;

import java.util.List;
import java.util.StringJoiner;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.NoMoreArgumentsException;
import me.fixeddev.commandflow.stack.ArgumentStack;
import me.fixeddev.commandflow.stack.StackSnapshot;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class SimpleArgumentStack
implements ArgumentStack {
    protected List<String> originalArguments;
    protected SimpleArgumentStack parent;
    private int position = 0;

    public SimpleArgumentStack(List<String> originalArguments) {
        this.originalArguments = originalArguments;
    }

    protected SimpleArgumentStack(List<String> originalArguments, int position) {
        this.originalArguments = originalArguments;
        this.position = position;
    }

    protected SimpleArgumentStack(List<String> originalArguments, SimpleArgumentStack parent) {
        this.originalArguments = originalArguments;
        this.parent = parent;
    }

    @Override
    public boolean hasNext() {
        return this.originalArguments.size() > this.position;
    }

    @Override
    public String next() throws NoMoreArgumentsException {
        if (!this.hasNext()) {
            throw new NoMoreArgumentsException(this.originalArguments.size(), this.position);
        }
        if (this.parent != null) {
            ++this.parent.position;
        }
        return this.originalArguments.get(this.position++);
    }

    @Override
    public String peek() throws NoMoreArgumentsException {
        if (!this.hasNext()) {
            throw new NoMoreArgumentsException(this.originalArguments.size(), this.position);
        }
        return this.originalArguments.get(this.position);
    }

    @Override
    public String current() {
        return this.originalArguments.get(this.position - 1);
    }

    @Override
    public String remove() {
        if (this.position == 0) {
            throw new IllegalStateException("You must advance the stack at least 1 time before calling remove!");
        }
        String toRemove = this.current();
        this.getBacking().remove(toRemove);
        --this.position;
        if (this.parent != null) {
            --this.position;
        }
        return toRemove;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getSize() {
        return this.originalArguments.size();
    }

    @Override
    public int getArgumentsLeft() {
        return this.getSize() - this.getPosition();
    }

    @Override
    public String nextQuoted() {
        if (this.position >= this.originalArguments.size()) {
            throw new NoMoreArgumentsException();
        }
        String argument = this.originalArguments.get(this.position);
        char quote = argument.charAt(0);
        if (quote != '\"' && quote != '\'') {
            ++this.position;
            return argument;
        }
        argument = argument.substring(1);
        StringJoiner joiner = new StringJoiner(" ");
        while (true) {
            boolean escaped = false;
            StringBuilder builder = new StringBuilder(argument.length());
            for (int i = 0; i < argument.length(); ++i) {
                char current = argument.charAt(i);
                if (current == '\\') {
                    escaped = true;
                    continue;
                }
                if (current == quote) {
                    if (escaped) {
                        builder.append(quote);
                        escaped = false;
                        continue;
                    }
                    ++this.position;
                    String extra = argument.substring(i + 1);
                    if (!extra.isEmpty()) {
                        this.originalArguments.add(this.position, extra);
                    }
                    joiner.add(builder.toString());
                    return joiner.toString();
                }
                if (escaped) {
                    builder.append('\\');
                    escaped = false;
                }
                builder.append(current);
            }
            if (builder.length() > 0) {
                joiner.add(builder.toString());
            }
            ++this.position;
            if (this.position >= this.originalArguments.size()) break;
            argument = this.originalArguments.get(this.position);
        }
        return joiner.toString();
    }

    @Override
    public int nextInt() throws ArgumentParseException {
        String next = this.next();
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.integer", TextComponent.of(next)));
        }
    }

    @Override
    public float nextFloat() throws ArgumentParseException {
        String next = this.next();
        try {
            return Float.parseFloat(next);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.float", TextComponent.of(next)));
        }
    }

    @Override
    public double nextDouble() throws ArgumentParseException {
        String next = this.next();
        try {
            return Double.parseDouble(next);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.double", TextComponent.of(next)));
        }
    }

    @Override
    public byte nextByte() throws ArgumentParseException {
        String next = this.next();
        try {
            return Byte.parseByte(next);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.byte", TextComponent.of(next)));
        }
    }

    @Override
    public boolean nextBoolean() throws ArgumentParseException {
        String next = this.next();
        if (!next.equalsIgnoreCase("true") && !next.equalsIgnoreCase("false")) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.boolean", TextComponent.of(next)));
        }
        return Boolean.parseBoolean(next);
    }

    @Override
    public long nextLong() throws ArgumentParseException {
        String next = this.next();
        try {
            return Long.parseLong(next);
        }
        catch (NumberFormatException e) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.long", TextComponent.of(next)));
        }
    }

    @Override
    public void markAsConsumed() {
        int oldPosition = this.position;
        this.position = this.originalArguments.size();
        if (this.parent != null) {
            int offset = this.position - oldPosition;
            this.parent.position += offset;
        }
    }

    @Override
    public void applySnapshot(StackSnapshot snapshot, boolean changeArgs) {
        int offset = snapshot.position - this.position;
        this.position = snapshot.position;
        if (this.parent != null) {
            this.parent.position = offset < 0 ? (this.parent.position += offset) : (this.parent.position -= offset);
        }
        if (changeArgs) {
            int index = 0;
            if (this.originalArguments.size() < snapshot.backing.size()) {
                for (String arg : snapshot.backing) {
                    if (this.originalArguments.size() > index) {
                        this.originalArguments.set(index, arg);
                    } else {
                        this.originalArguments.add(index, arg);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public List<String> getBacking() {
        return this.originalArguments;
    }

    @Override
    public ArgumentStack getSlice(int start, int end) {
        return new SimpleArgumentStack(this.originalArguments.subList(start, end), this);
    }

    @Override
    public StackSnapshot getSnapshot(boolean useCurrentPos) {
        return new StackSnapshot(this, useCurrentPos ? this.position : -1);
    }
}

