/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.translator;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.fixeddev.commandflow.ComponentUtil;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.translator.TranslationProvider;
import me.fixeddev.commandflow.translator.Translator;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class DefaultTranslator
implements Translator {
    private TranslationProvider provider;
    private Function<String, TextComponent> stringToComponent;
    private static final Pattern FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public DefaultTranslator(TranslationProvider provider) {
        this(provider, TextComponent::of);
    }

    public DefaultTranslator(TranslationProvider provider, Function<String, TextComponent> stringTextComponentFunction) {
        this.provider = provider;
        this.stringToComponent = stringTextComponentFunction;
    }

    @Override
    public Component translate(Component component, Namespace namespace) {
        if (!(component instanceof TranslatableComponent)) {
            return component;
        }
        TranslatableComponent translatableComponent = (TranslatableComponent)component;
        return this.newConvert(translatableComponent, namespace);
    }

    @Override
    public void setProvider(TranslationProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The provided provider is null!");
        }
        this.provider = provider;
    }

    @Override
    public void setConverterFunction(Function<String, TextComponent> stringToComponent) {
        this.stringToComponent = stringToComponent;
    }

    private TextComponent newConvert(TranslatableComponent component, Namespace namespace) {
        String trans = this.provider.getTranslation(namespace, component.key());
        if (trans == null || trans.isEmpty()) {
            return TextComponent.of(component.key());
        }
        TextComponent translated = (TextComponent)((TextComponent.Builder)TextComponent.builder(trans).style(component.style())).build();
        int[] iw = new int[]{0};
        return (TextComponent)ComponentUtil.recursiveDynamicReplace(translated, FORMAT, (s, matcher) -> {
            String formatCode = matcher.group(2);
            switch (formatCode.charAt(0)) {
                case 'd': 
                case 's': {
                    int n;
                    String withIndex = matcher.group(1);
                    List<Component> args = component.args();
                    if (withIndex != null) {
                        n = Integer.parseInt(withIndex) - 1;
                    } else {
                        int n2 = iw[0];
                        n = n2;
                        iw[0] = n2 + 1;
                    }
                    int withIndexInt = n;
                    if (args.size() > withIndexInt) {
                        Component component1 = component.args().get(withIndexInt);
                        return component1 instanceof TextComponent ? (TextComponent)component1 : this.newConvert(component, namespace);
                    }
                    return this.stringToComponent.apply("%" + formatCode.charAt(0));
                }
                case '%': {
                    return this.stringToComponent.apply("%");
                }
            }
            return TextComponent.of(s);
        });
    }
}

