/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import net.kyori.text.BuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.ComponentBuilder;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.Style;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import net.kyori.text.serializer.ComponentSerializer;
import net.kyori.text.serializer.gson.NameMapSerializer;
import net.kyori.text.serializer.gson.StyleSerializer;
import net.kyori.text.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String EXTRA = "extra";

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, (Object)INSTANCE).registerTypeAdapter(Style.class, (Object)StyleSerializer.INSTANCE).registerTypeAdapter(ClickEvent.Action.class, new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)).registerTypeAdapter(HoverEvent.Action.class, new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter(TextColorWrapper.class, (Object)new TextColorWrapper.Serializer()).registerTypeAdapter(TextColor.class, new NameMapSerializer<TextColor>("text color", TextColor.NAMES)).registerTypeAdapter(TextDecoration.class, new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES));
        return builder;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)GSON.fromJson(string, Component.class);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson((Object)component);
    }

    @Deprecated
    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize0(json, context);
    }

    private BuildableComponent<?, ?> deserialize0(JsonElement element, JsonDeserializationContext context) throws JsonParseException {
        Style style;
        ComponentBuilder<TextComponent, TextComponent.Builder> component;
        if (element.isJsonPrimitive()) {
            return TextComponent.of(element.getAsString());
        }
        if (element.isJsonArray()) {
            ComponentBuilder parent = null;
            for (JsonElement childElement : element.getAsJsonArray()) {
                BuildableComponent<?, ?> child = this.deserialize0(childElement, context);
                if (parent == null) {
                    parent = child.toBuilder();
                    continue;
                }
                parent.append(child);
            }
            if (parent == null) {
                throw new JsonParseException("Don't know how to turn " + element + " into a Component");
            }
            return parent.build();
        }
        if (!element.isJsonObject()) {
            throw new JsonParseException("Don't know how to turn " + element + " into a Component");
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has(TEXT)) {
            component = TextComponent.builder(object.get(TEXT).getAsString());
        } else if (object.has(TRANSLATE)) {
            String key = object.get(TRANSLATE).getAsString();
            if (!object.has(TRANSLATE_WITH)) {
                component = TranslatableComponent.builder(key);
            } else {
                JsonArray with = object.getAsJsonArray(TRANSLATE_WITH);
                ArrayList args = new ArrayList(with.size());
                int size = with.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement argElement = with.get(i);
                    args.add(this.deserialize0(argElement, context));
                }
                component = TranslatableComponent.builder(key).args(args);
            }
        } else {
            throw GsonComponentSerializer.notSureHowToDeserialize(element);
        }
        if (object.has(EXTRA)) {
            JsonArray extra = object.getAsJsonArray(EXTRA);
            int size = extra.size();
            for (int i = 0; i < size; ++i) {
                JsonElement extraElement = extra.get(i);
                component.append(this.deserialize0(extraElement, context));
            }
        }
        if (!(style = (Style)context.deserialize(element, Style.class)).isEmpty()) {
            component.style(style);
        }
        return component.build();
    }

    @Deprecated
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement style;
        JsonObject object = new JsonObject();
        if (src instanceof TextComponent) {
            object.addProperty(TEXT, ((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            object.addProperty(TRANSLATE, tc.key());
            if (!tc.args().isEmpty()) {
                JsonArray with = new JsonArray();
                for (Component arg : tc.args()) {
                    with.add(context.serialize((Object)arg));
                }
                object.add(TRANSLATE_WITH, (JsonElement)with);
            }
        } else {
            throw GsonComponentSerializer.notSureHowToSerialize(src);
        }
        if (!src.children().isEmpty()) {
            JsonArray extra = new JsonArray();
            for (Component child : src.children()) {
                extra.add(context.serialize((Object)child));
            }
            object.add(EXTRA, (JsonElement)extra);
        }
        if (src.hasStyling() && (style = context.serialize((Object)src.style())).isJsonObject()) {
            for (Map.Entry entry : ((JsonObject)style).entrySet()) {
                object.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return object;
    }

    private static JsonParseException notSureHowToDeserialize(JsonElement element) {
        return new JsonParseException("Don't know how to turn " + element + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

