/*
 * Decompiled with CFR 0.152.
 */
package online.starsmc.simplesetspawn.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public interface ChatUtil {
    public static String translate(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static List<String> translate(List<String> stringList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String list : stringList) {
            arrayList.add(ChatUtil.translate(list));
        }
        return arrayList;
    }

    public static void sendMsgPlayer(Player player, String message) {
        player.sendMessage(ChatUtil.translate(message).replace("<player>", player.getName()));
    }

    public static void sendMsgPlayerPrefix(Player player, String message) {
        ChatUtil.sendMsgPlayer(player, ChatUtil.getPrefixGame() + message);
    }

    public static void sendMsgPlayer(Player player, List<String> stringList) {
        stringList.forEach(message -> ChatUtil.sendMsgPlayer(player, message));
    }

    public static void sendMsgPlayerPrefix(Player player, List<String> stringList) {
        stringList.forEach(message -> ChatUtil.sendMsgPlayerPrefix(player, message));
    }

    public static void sendMsgSender(CommandSender sender, String message) {
        sender.sendMessage(ChatUtil.translate(message));
    }

    public static void sendMsgSenderPrefix(CommandSender sender, String message) {
        ChatUtil.sendMsgSender(sender, ChatUtil.getPrefixGame() + message);
    }

    public static void sendMsgSender(CommandSender sender, List<String> stringList) {
        stringList.forEach(message -> ChatUtil.sendMsgSender(sender, message));
    }

    public static void sendMsgSenderPrefix(CommandSender sender, List<String> stringList) {
        stringList.forEach(message -> ChatUtil.sendMsgSenderPrefix(sender, message));
    }

    public static String getPrefixGame() {
        return "&8[&bSimpleSetSpawn&8] ";
    }

    public static String getPrefix() {
        return "[SimpleSetSpawn] ";
    }
}

