/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.assisted.provision;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import team.unnamed.inject.assisted.ValueFactory;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.resolve.solution.InjectableConstructor;
import team.unnamed.inject.util.ElementFormatter;

public class ProxiedFactoryProvider<T>
extends StdProvider<T> {
    private final Class<? extends ValueFactory> factory;
    private final Method method;
    private final List<InjectedKey<?>> keys;
    private final InjectableConstructor constructor;
    private final Key<?> key;
    private T factoryInstance;

    ProxiedFactoryProvider(Class<? extends ValueFactory> factory, Method method, List<InjectedKey<?>> keys, InjectableConstructor constructor, Key<?> key) {
        this.factory = factory;
        this.method = method;
        this.keys = keys;
        this.constructor = constructor;
        this.key = key;
    }

    public Class<? extends ValueFactory> getFactory() {
        return this.factory;
    }

    public Method getFactoryMethod() {
        return this.method;
    }

    public Key<?> getBuildType() {
        return this.key;
    }

    public Constructor<?> getTargetConstructor() {
        return this.constructor.getMember();
    }

    private Object createInstance(InjectorImpl injector, Object[] extras) {
        HashMap values = new HashMap();
        for (int i = 0; i < extras.length; ++i) {
            Key<?> valueKey = this.keys.get(i).getKey();
            Iterator<InjectedKey<?>> value = extras[i];
            values.put(valueKey, value);
        }
        Object[] givenArgs = new Object[this.constructor.getKeys().size()];
        int i = 0;
        for (InjectedKey<?> injection : this.constructor.getKeys()) {
            if (injection.isAssisted()) {
                givenArgs[i] = values.get(injection.getKey());
            } else {
                Object val = injector.getInstance(injector.stackForThisThread(), injection.getKey(), true);
                givenArgs[i] = val;
            }
            ++i;
        }
        try {
            Object instance = ((Constructor)this.constructor.getMember()).newInstance(givenArgs);
            injector.injectMembers(this.key.getType(), instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            injector.stackForThisThread().attach("Errors while invoking assisted constructor " + ElementFormatter.formatConstructor(this.constructor.getMember(), this.keys), e);
            return null;
        }
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        this.factoryInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.factory}, (proxy, method, args) -> {
            if (method.equals(this.method)) {
                return this.createInstance(injector, args);
            }
            switch (method.getName()) {
                case "equals": {
                    return false;
                }
                case "hashCode": {
                    return 0;
                }
                case "toString": {
                    return this.factory.getName() + " Trew-generated implementation";
                }
            }
            return null;
        });
        this.injected = true;
    }

    @Override
    public T get() {
        return this.factoryInstance;
    }
}

