/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import team.unnamed.inject.error.ErrorAttachable;
import team.unnamed.inject.error.Errors;
import team.unnamed.inject.util.Validate;

public class ErrorAttachableImpl
implements ErrorAttachable {
    private final List<String> errorMessages = new LinkedList<String>();

    @Override
    public void attach(String ... messages) {
        Validate.notNull(messages, "errorMessages", new Object[0]);
        Collections.addAll(this.errorMessages, messages);
    }

    @Override
    public void attach(String header, Throwable error) {
        Validate.notNull(error, "error", new Object[0]);
        String stackTrace = Errors.getStackTrace(error);
        if (header != null) {
            stackTrace = header + "\n" + stackTrace;
        }
        this.errorMessages.add(stackTrace);
    }

    @Override
    public void attachAll(ErrorAttachable attachable) {
        this.errorMessages.addAll(attachable.getErrorMessages());
    }

    @Override
    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    @Override
    public List<String> getErrorMessages() {
        return new ArrayList<String>(this.errorMessages);
    }

    @Override
    public void applySnapshot(List<String> errorMessages) {
        this.errorMessages.clear();
        this.errorMessages.addAll(errorMessages);
    }

    @Override
    public String formatMessages() {
        return Errors.formatErrorMessages(this.errorMessages);
    }

    @Override
    public int errorCount() {
        return this.errorMessages.size();
    }

    @Override
    public void reportAttachedErrors() {
        throw new UnsupportedOperationException("The attached errors cannot be reported here!");
    }
}

