/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.impl;

import java.util.List;
import javax.inject.Provider;
import team.unnamed.inject.Injector;
import team.unnamed.inject.error.InjectionException;
import team.unnamed.inject.impl.AnnotationScanner;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.ProvisionHandle;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.resolve.ComponentResolver;
import team.unnamed.inject.resolve.solution.InjectableConstructor;
import team.unnamed.inject.resolve.solution.InjectableMember;
import team.unnamed.inject.util.Validate;

public class InjectorImpl
implements Injector {
    public static final Object ABSENT_INSTANCE = new Object();
    protected final ThreadLocal<ProvisionStack> provisionStackThreadLocal = new ThreadLocal();
    private final ProvisionHandle provisionHandle;
    private final BinderImpl binder;

    public InjectorImpl(BinderImpl binder) {
        this.binder = Validate.notNull(binder);
        this.provisionHandle = new ProvisionHandle(this, binder);
    }

    public Object getValue(InjectedKey<?> key, ProvisionStack stack) {
        List<String> snapshot = stack.getErrorMessages();
        Object value = this.getInstance(stack, key.getKey(), true);
        if (value == null && !key.isOptional()) {
            return ABSENT_INSTANCE;
        }
        if (key.isOptional()) {
            stack.applySnapshot(snapshot);
        }
        return value;
    }

    @Override
    public <T> T getInstance(TypeReference<T> type) {
        boolean stackWasNotPresent = this.provisionStackThreadLocal.get() == null;
        T value = this.getInstance(this.stackForThisThread(), Key.of(type), true);
        if (stackWasNotPresent) {
            this.removeStackFromThisThread();
        }
        return value;
    }

    @Override
    public <T> void injectMembers(TypeReference<T> type, T instance) {
        boolean stackWasNotPresent = this.provisionStackThreadLocal.get() == null;
        this.injectMembers(this.stackForThisThread(), Key.of(type), instance);
        if (stackWasNotPresent) {
            this.removeStackFromThisThread();
        }
    }

    public ProvisionStack stackForThisThread() {
        ProvisionStack stack = this.provisionStackThreadLocal.get();
        if (stack == null) {
            stack = new ProvisionStack();
            this.provisionStackThreadLocal.set(stack);
        }
        return stack;
    }

    protected void removeStackFromThisThread() {
        ProvisionStack stack = this.provisionStackThreadLocal.get();
        this.provisionStackThreadLocal.set(null);
        if (stack != null && stack.hasErrors()) {
            throw new InjectionException(stack.formatMessages());
        }
    }

    @Override
    public <T> Provider<? extends T> getProvider(TypeReference<T> key) {
        return this.binder.getProvider(Key.of(key));
    }

    @Override
    public void injectStaticMembers(Class<?> clazz) {
        boolean stackWasNotPresent = this.provisionStackThreadLocal.get() == null;
        this.injectMembers(this.stackForThisThread(), Key.of(TypeReference.of(clazz)), null);
        if (stackWasNotPresent) {
            this.removeStackFromThisThread();
        }
    }

    public <T> void injectMembers(ProvisionStack stack, Key<T> type, T instance) {
        if (instance != null) {
            stack.push(type, instance);
        }
        for (InjectableMember injectableMember : ComponentResolver.fields().get(type.getType())) {
            injectableMember.inject(this, stack, instance);
        }
        for (InjectableMember injectableMember : ComponentResolver.methods().get(type.getType())) {
            injectableMember.inject(this, stack, instance);
        }
        if (instance != null) {
            stack.pop();
        }
    }

    public <T> T getInstance(Key<T> type, boolean useExplicitBindings) {
        return this.getInstance(this.stackForThisThread(), type, useExplicitBindings);
    }

    public <T> T getInstance(ProvisionStack stack, Key<T> type, boolean useExplicitBindings) {
        StdProvider<T> provider;
        Class<T> rawType = type.getType().getRawType();
        if (rawType == Injector.class || rawType == InjectorImpl.class) {
            InjectorImpl value = this;
            return (T)value;
        }
        if (stack.has(type)) {
            return stack.get(type);
        }
        AnnotationScanner.bind(type.getType(), this.binder);
        AnnotationScanner.scope(type.getType(), this.binder);
        if (useExplicitBindings && (provider = this.provisionHandle.getProviderAndInject(stack, type)) != null) {
            return provider.get(type);
        }
        InjectableConstructor constructor = ComponentResolver.constructor().get(stack, type.getType());
        if (constructor == null) {
            return null;
        }
        Object instance = constructor.inject(this, stack, null);
        Object value = instance;
        if (value != null) {
            this.injectMembers(stack, type, value);
        }
        return (T)value;
    }
}

