/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.multibinding;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Provider;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.multibinding.CollectionCreator;
import team.unnamed.inject.provision.StdProvider;

class CollectionBoundProvider<E>
extends StdProvider<Collection<E>> {
    private final Collection<Provider<? extends E>> delegates;
    private final CollectionCreator collectionCreator;

    CollectionBoundProvider(CollectionCreator collectionCreator) {
        this.collectionCreator = collectionCreator;
        this.delegates = collectionCreator.create();
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        for (Provider<E> provider : this.delegates) {
            if (provider instanceof StdProvider) {
                ((StdProvider)provider).inject(stack, injector);
                continue;
            }
            injector.injectMembers(stack, Key.of(TypeReference.of(provider.getClass())), provider);
        }
        this.injected = true;
    }

    @Override
    public Collection<E> get() {
        Collection<E> collection = this.collectionCreator.create();
        for (Provider<E> delegate : this.delegates) {
            collection.add(delegate.get());
        }
        return collection;
    }

    public Collection<Provider<? extends E>> getProviders() {
        return Collections.unmodifiableCollection(this.delegates);
    }

    Collection<Provider<? extends E>> getModifiableProviderCollection() {
        return this.delegates;
    }

    public String toString() {
        return "CollectionMultiBound(" + this.delegates + ")";
    }
}

