/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.multibinding;

import java.util.Collection;
import javax.inject.Provider;
import team.unnamed.inject.Binder;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.LinkedBuilder;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.multibinding.CollectionBoundProvider;
import team.unnamed.inject.multibinding.CollectionCreator;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

class CollectionMultiBindingBuilderImpl<E>
implements Binder.CollectionMultiBindingBuilder<E>,
LinkedBuilder<Binder.CollectionMultiBindingBuilder<E>, E> {
    private final BinderImpl binder;
    private final Key<? extends Collection<E>> collectionKey;
    private final Key<E> elementKey;
    private final CollectionCreator collectionCreator;

    public CollectionMultiBindingBuilderImpl(BinderImpl binder, Key<? extends Collection<E>> collectionKey, Key<E> elementKey, CollectionCreator collectionCreator) {
        this.binder = binder;
        this.collectionKey = collectionKey;
        this.elementKey = elementKey;
        this.collectionCreator = collectionCreator;
    }

    @Override
    public void in(Scope scope) {
        Validate.notNull(scope, "scope", new Object[0]);
        Provider<Collection<Object>> provider = Providers.unwrap(this.binder.getProvider(this.collectionKey));
        if (provider != null) {
            provider = provider instanceof StdProvider ? ((StdProvider)provider).withScope(this.collectionKey, scope) : scope.scope(provider);
            this.binder.$unsafeBind(this.collectionKey, provider);
        }
    }

    @Override
    public Key<E> key() {
        return this.elementKey;
    }

    @Override
    public Binder.CollectionMultiBindingBuilder<E> toProvider(Provider<? extends E> provider) {
        Provider<? extends Collection<E>> delegate;
        Validate.notNull(provider, "provider", new Object[0]);
        StdProvider<? extends Collection<E>> collectionProvider = this.binder.getProvider(this.collectionKey);
        if (collectionProvider == null) {
            collectionProvider = new CollectionBoundProvider(this.collectionCreator);
            this.binder.$unsafeBind(this.collectionKey, collectionProvider);
        }
        if (!((delegate = Providers.unwrap(collectionProvider)) instanceof CollectionBoundProvider)) {
            throw new IllegalStateException("The key '" + this.collectionKey + "' is already bound and it isn't a multibinding!");
        }
        CollectionBoundProvider collectionDelegate = (CollectionBoundProvider)delegate;
        collectionDelegate.getModifiableProviderCollection().add(provider);
        return this;
    }

    @Override
    public Binder.CollectionMultiBindingBuilder<E> toInstance(E instance) {
        return this.toProvider(Providers.instanceProvider(this.elementKey, instance));
    }
}

