/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.multibinding;

import java.util.Map;
import javax.inject.Provider;
import team.unnamed.inject.Binder;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.LinkedBuilder;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.multibinding.MapBoundProvider;
import team.unnamed.inject.multibinding.MapCreator;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

class MapMultiBindingBuilderImpl<K, V>
implements Binder.MapMultiBindingBuilder<K, V> {
    private final BinderImpl binder;
    private final MapCreator mapCreator;
    private final Key<Map<K, V>> mapKey;
    private final Key<V> valueKey;

    MapMultiBindingBuilderImpl(BinderImpl binder, MapCreator mapCreator, Key<Map<K, V>> mapKey, Key<V> valueKey) {
        this.binder = binder;
        this.mapCreator = mapCreator;
        this.mapKey = mapKey;
        this.valueKey = valueKey;
    }

    @Override
    public void in(Scope scope) {
        Validate.notNull(scope, "scope", new Object[0]);
        Provider<Map<K, V>> provider = Providers.unwrap(this.binder.getProvider(this.mapKey));
        if (provider != null) {
            provider = provider instanceof StdProvider ? ((StdProvider)provider).withScope(this.mapKey, scope) : scope.scope(provider);
            this.binder.$unsafeBind(this.mapKey, provider);
        }
    }

    @Override
    public Binder.KeyBinder<K, V> bind(K key) {
        return new KeyBinderImpl(key);
    }

    class KeyBinderImpl
    implements Binder.KeyBinder<K, V>,
    LinkedBuilder<Binder.MapMultiBindingBuilder<K, V>, V> {
        private final K key;

        private KeyBinderImpl(K key) {
            this.key = key;
        }

        @Override
        public Key<V> key() {
            return MapMultiBindingBuilderImpl.this.valueKey;
        }

        @Override
        public Binder.MapMultiBindingBuilder<K, V> toProvider(Provider<? extends V> provider) {
            Provider delegate;
            Validate.notNull(provider, "provider", new Object[0]);
            StdProvider mapProvider = MapMultiBindingBuilderImpl.this.binder.getProvider(MapMultiBindingBuilderImpl.this.mapKey);
            if (mapProvider == null) {
                mapProvider = new MapBoundProvider(MapMultiBindingBuilderImpl.this.mapCreator);
                MapMultiBindingBuilderImpl.this.binder.$unsafeBind(MapMultiBindingBuilderImpl.this.mapKey, mapProvider);
            }
            if (!((delegate = Providers.unwrap(mapProvider)) instanceof MapBoundProvider)) {
                throw new IllegalStateException("The key '" + MapMultiBindingBuilderImpl.this.mapKey + "' is already bound and it isn't a multibinding!");
            }
            MapBoundProvider collectionDelegate = (MapBoundProvider)delegate;
            collectionDelegate.getModifiableProviderMap().put(this.key, provider);
            return MapMultiBindingBuilderImpl.this;
        }

        @Override
        public Binder.MapMultiBindingBuilder<K, V> toInstance(V instance) {
            return this.toProvider(Providers.instanceProvider(this.key(), instance));
        }
    }
}

