/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.provision;

import java.util.Objects;
import javax.inject.Provider;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

public class DelegatingStdProvider<T>
extends StdProvider<T>
implements Provider<T> {
    private final Provider<T> delegate;

    public DelegatingStdProvider(Provider<T> delegate) {
        this.delegate = Validate.notNull(delegate, "delegate", new Object[0]);
    }

    public DelegatingStdProvider(boolean injected, Provider<T> delegate) {
        this(delegate);
        this.setInjected(injected);
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        Providers.inject(stack, injector, this.delegate);
        this.injected = true;
    }

    @Override
    public boolean onBind(BinderImpl binder, Key<?> key) {
        if (this.delegate instanceof StdProvider) {
            return ((StdProvider)this.delegate).onBind(binder, key);
        }
        return true;
    }

    @Override
    public Provider<T> withScope(Key<?> match, Scope scope) {
        if (this.delegate instanceof StdProvider) {
            return ((StdProvider)this.delegate).withScope(match, scope);
        }
        return super.withScope(match, scope);
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelegatingStdProvider)) {
            return false;
        }
        DelegatingStdProvider that = (DelegatingStdProvider)o;
        return that.isInjected() == this.isInjected() && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.isInjected(), this.delegate);
    }
}

