/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.provision.std.generic;

import javax.inject.Provider;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.provision.std.ScopedProvider;
import team.unnamed.inject.provision.std.generic.GenericProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

public class ToGenericProvider<T>
extends ScopedProvider<T>
implements Provider<T> {
    private final GenericProvider<T> provider;
    private Scope scope;

    public ToGenericProvider(GenericProvider<T> provider) {
        this.provider = Validate.notNull(provider, "provider", new Object[0]);
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        this.injected = true;
    }

    @Override
    public boolean onBind(BinderImpl binder, Key<?> key) {
        boolean isRawType = key.isPureRawType();
        if (!isRawType) {
            binder.attach("You must bound the raw-type to a GenericProvider, not a parameterized type! (key: " + key + ", genericProvider: " + this.provider + ")");
        }
        return isRawType;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Key was bound to a generic provider, it cannot complete a raw-type!\n\tProvider: " + this.provider);
    }

    @Override
    public T get(Key<?> bound) {
        return this.provider.get(bound);
    }

    @Override
    public Provider<T> withScope(Key<?> match, Scope scope) {
        if (scope != null) {
            this.scope = scope;
        }
        if (match.isPureRawType()) {
            return this;
        }
        return new SyntheticGenericProvider(match, scope == null ? this.scope : scope);
    }

    @Override
    public boolean requiresJitScoping() {
        return true;
    }

    public class SyntheticGenericProvider
    extends StdProvider<T>
    implements Provider<T> {
        private final Scope scope;
        private final Provider<T> scoped;

        public SyntheticGenericProvider(Key<?> match, Scope scope) {
            this.scope = scope;
            Provider unscoped = ToGenericProvider.this.provider.asConstantProvider(match);
            this.scoped = scope == null ? unscoped : scope.scope(unscoped);
            this.setInjected(true);
        }

        @Override
        public T get() {
            return this.scoped.get();
        }

        @Override
        public Provider<T> withScope(Key<?> match, Scope scope) {
            Validate.argument(this.scope == scope, "Not the same scope on GenericProvider!", new Object[0]);
            return new SyntheticGenericProvider(match, scope);
        }
    }
}

