/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import team.unnamed.inject.InjectAll;
import team.unnamed.inject.InjectIgnore;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.resolve.ComponentResolver;
import team.unnamed.inject.resolve.Solution;
import team.unnamed.inject.resolve.solution.InjectableField;

public final class FieldResolver {
    FieldResolver() {
    }

    public List<InjectableField> get(TypeReference<?> type) {
        Solution solution = ComponentResolver.SOLUTIONS.get(type);
        if (solution == null || solution.fields == null) {
            if (solution == null) {
                solution = new Solution();
                ComponentResolver.SOLUTIONS.put(type, solution);
            }
            if (solution.fields == null) {
                solution.fields = this.resolve(type);
            }
        }
        return solution.fields;
    }

    public List<InjectableField> resolve(TypeReference<?> type) {
        Class<?> clazz;
        ArrayList<InjectableField> fields = new ArrayList<InjectableField>();
        for (Class<?> checking = clazz = type.getRawType(); checking != null && checking != Object.class; checking = checking.getSuperclass()) {
            boolean injectAll = checking.isAnnotationPresent(InjectAll.class);
            for (Field field : checking.getDeclaredFields()) {
                if (injectAll ? field.isSynthetic() || field.isAnnotationPresent(InjectIgnore.class) : !field.isAnnotationPresent(Inject.class)) continue;
                TypeReference<?> fieldType = type.getFieldType(field);
                InjectedKey<?> key = ComponentResolver.KEY_RESOLVER.keyOf(fieldType, field.getAnnotations());
                fields.add(new InjectableField(type, key, field));
            }
        }
        return fields;
    }
}

