/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Qualifier;
import team.unnamed.inject.assisted.Assist;
import team.unnamed.inject.impl.Annotations;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;

public final class KeyResolver {
    KeyResolver() {
    }

    public List<InjectedKey<?>> keysOf(TypeReference<?> declaringType, Parameter[] parameters) {
        ArrayList keys = new ArrayList(parameters.length);
        for (Parameter parameter : parameters) {
            Type type = parameter.getParameterizedType();
            Annotation[] annotations = parameter.getAnnotations();
            TypeReference<?> parameterType = declaringType.resolve(type);
            keys.add(this.keyOf(parameterType, annotations));
        }
        return keys;
    }

    public <T> InjectedKey<T> keyOf(TypeReference<T> type, Annotation[] annotations) {
        boolean optional = false;
        boolean assisted = false;
        Class<? extends Annotation> qualifierType = null;
        Annotation qualifier = null;
        for (Annotation annotation : annotations) {
            String simpleName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!optional && (simpleName = annotationType.getSimpleName()).equalsIgnoreCase("Nullable")) {
                optional = true;
                continue;
            }
            if (!assisted && annotationType == Assist.class) {
                assisted = true;
            }
            if (qualifierType != null || qualifier != null || !annotationType.isAnnotationPresent(Qualifier.class)) continue;
            if (Annotations.containsOnlyDefaultValues(annotation)) {
                qualifierType = annotationType;
                continue;
            }
            qualifier = annotation;
        }
        Key<T> key = Key.of(type, qualifierType, qualifier);
        return new InjectedKey<T>(key, optional, assisted);
    }
}

