/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve.solution;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.resolve.solution.InjectableMember;
import team.unnamed.inject.util.ElementFormatter;
import team.unnamed.inject.util.Validate;

public class InjectableField
implements InjectableMember {
    private final TypeReference<?> declaringType;
    private final InjectedKey<?> key;
    private final Field field;

    public InjectableField(TypeReference<?> declaringType, InjectedKey<?> key, Field field) {
        this.declaringType = Validate.notNull(declaringType, "declaringType", new Object[0]);
        this.key = Validate.notNull(key, "key", new Object[0]);
        this.field = Validate.notNull(field, "field", new Object[0]);
        Validate.doesntRequiresContext(key.getKey());
        this.field.setAccessible(true);
    }

    @Override
    public TypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Field getMember() {
        return this.field;
    }

    @Override
    public Object inject(InjectorImpl injector, ProvisionStack stack, Object target) {
        if (target == null ^ Modifier.isStatic(this.field.getModifiers())) {
            return null;
        }
        Object value = injector.getValue(this.key, stack);
        if (value == InjectorImpl.ABSENT_INSTANCE) {
            stack.attach("Cannot inject '" + this.field.getName() + "' field.\n\tAt:" + this.declaringType + "\n\tReason: Cannot get value for required key \n\tRequired Key: " + this.key.getKey());
            return null;
        }
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException e) {
            stack.attach("Cannot inject field " + ElementFormatter.formatField(this.field, this.key), e);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectableField that = (InjectableField)o;
        return this.declaringType.equals(that.declaringType) && this.key.equals(that.key) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.declaringType, this.key, this.field);
    }
}

