/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.scope;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Provider;
import team.unnamed.inject.scope.Scope;

public final class LazySingletonScope
implements Scope {
    @Override
    public <T> Provider<T> scope(Provider<T> unscoped) {
        if (unscoped instanceof LazySingletonProvider) {
            return unscoped;
        }
        return new LazySingletonProvider<T>(unscoped);
    }

    static class LazySingletonProvider<T>
    implements Provider<T> {
        private final Lock instanceLock = new ReentrantLock();
        private final Provider<T> delegate;
        private volatile T instance;

        LazySingletonProvider(Provider<T> unscoped) {
            this.delegate = unscoped;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                this.instanceLock.lock();
                try {
                    if (this.instance == null) {
                        this.instance = this.delegate.get();
                    }
                }
                finally {
                    this.instanceLock.unlock();
                }
            }
            return this.instance;
        }

        public String toString() {
            return "LazySingleton(" + this.delegate.toString() + ")";
        }
    }
}

