/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.fixeddev.commandflow.ContextSnapshot;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.part.CommandPart;

public interface CommandContext
extends Namespace {
    public ContextSnapshot getSnapshot();

    public void applySnapshot(ContextSnapshot var1);

    public void setCommand(Command var1, String var2);

    public void removeLastCommand();

    default public Command getCommand() {
        return this.getExecutionPath().get(this.getExecutionPath().size() - 1);
    }

    default public Command getRootCommand() {
        return this.getExecutionPath().get(0);
    }

    public List<Command> getExecutionPath();

    public List<String> getArguments();

    public List<String> getLabels();

    public List<CommandPart> getParts(String var1);

    default public Optional<CommandPart> getPart(String name) {
        return this.getPart(name, 0);
    }

    default public Optional<CommandPart> getPart(String name, int index) {
        List<CommandPart> parts = this.getParts(name);
        return Optional.ofNullable(index < parts.size() ? this.getParts(name).get(index) : null);
    }

    public boolean contains(CommandPart var1);

    public List<String> getRaw(CommandPart var1);

    public <V> List<V> getValues(CommandPart var1);

    default public <V> List<V> getValues(String partName) {
        return this.getPart(partName).map(this::getValues).orElse(Collections.emptyList());
    }

    default public <V> Optional<V> getValue(CommandPart part) {
        List<V> values = this.getValues(part);
        return Optional.ofNullable(values != null && values.size() > 0 ? (Object)values.get(0) : null);
    }

    default public <V> Optional<V> getValue(String partName) {
        return this.getPart(partName).flatMap(this::getValue);
    }

    public boolean hasValue(CommandPart var1);

    public <T> void setValue(CommandPart var1, T var2);

    public <T> void setValues(CommandPart var1, List<T> var2);

    public void setRaw(CommandPart var1, List<String> var2);
}

