/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.annotated.AnnotatedCommandTreeBuilder;
import me.fixeddev.commandflow.annotated.CommandClass;
import me.fixeddev.commandflow.annotated.ReflectionInstanceCreator;
import me.fixeddev.commandflow.annotated.ReflectionSubCommandHandler;
import me.fixeddev.commandflow.annotated.SubCommandInstanceCreator;
import me.fixeddev.commandflow.annotated.annotation.ArgOrSub;
import me.fixeddev.commandflow.annotated.annotation.Command;
import me.fixeddev.commandflow.annotated.annotation.Handler;
import me.fixeddev.commandflow.annotated.annotation.Required;
import me.fixeddev.commandflow.annotated.annotation.SubCommandClasses;
import me.fixeddev.commandflow.annotated.annotation.Usage;
import me.fixeddev.commandflow.annotated.builder.AnnotatedCommandBuilder;
import me.fixeddev.commandflow.annotated.builder.AnnotatedCommandBuilderImpl;
import me.fixeddev.commandflow.annotated.builder.CommandPartsNode;
import me.fixeddev.commandflow.annotated.builder.SubCommandsNode;
import me.fixeddev.commandflow.annotated.part.PartInjector;
import me.fixeddev.commandflow.command.Action;
import me.fixeddev.commandflow.part.defaults.SubCommandPart;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class AnnotatedCommandTreeBuilderImpl
implements AnnotatedCommandTreeBuilder {
    private final AnnotatedCommandBuilder builder;
    private final SubCommandInstanceCreator instanceCreator;

    public AnnotatedCommandTreeBuilderImpl(AnnotatedCommandBuilder builder, SubCommandInstanceCreator instanceCreator) {
        this.builder = builder;
        this.instanceCreator = instanceCreator;
    }

    public AnnotatedCommandTreeBuilderImpl(PartInjector injector) {
        this.builder = new AnnotatedCommandBuilderImpl(injector);
        this.instanceCreator = new ReflectionInstanceCreator();
    }

    @Override
    public List<me.fixeddev.commandflow.command.Command> fromClass(CommandClass commandClass) {
        Class<?> clazz = commandClass.getClass();
        Command rootCommandAnnotation = clazz.getAnnotation(Command.class);
        ArrayList<me.fixeddev.commandflow.command.Command> commandList = new ArrayList<me.fixeddev.commandflow.command.Command>();
        Method rootCommandMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            Command commandAnnotation = method.getAnnotation(Command.class);
            if (commandAnnotation == null) continue;
            if (commandAnnotation.names()[0].equals("")) {
                rootCommandMethod = method;
                continue;
            }
            me.fixeddev.commandflow.command.Command command = this.fromMethod(commandClass, commandAnnotation, method);
            if (command == null) continue;
            commandList.add(command);
        }
        if (rootCommandAnnotation != null) {
            return this.createRootCommand(commandClass, clazz, rootCommandAnnotation, commandList, rootCommandMethod);
        }
        return commandList;
    }

    private me.fixeddev.commandflow.command.Command fromMethod(CommandClass commandClass, Command commandAnnotation, Method method) {
        if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class && method.getReturnType() != Void.TYPE) {
            return null;
        }
        Usage usage = method.getAnnotation(Usage.class);
        String[] names = commandAnnotation.names();
        return this.builder.newCommand(names[0]).aliases(Arrays.asList(Arrays.copyOfRange(names, 1, names.length))).permission(commandAnnotation.permission()).permissionMessage(this.fromString(commandAnnotation.permissionMessage())).description(this.fromString(commandAnnotation.desc())).usage(usage).parts().ofMethodParameters(method, commandClass).action(method, commandClass).build();
    }

    @NotNull
    private List<me.fixeddev.commandflow.command.Command> createRootCommand(CommandClass commandClass, Class<?> clazz, Command rootCommandAnnotation, List<me.fixeddev.commandflow.command.Command> commandList, Method rootCommandMethod) {
        String[] names = rootCommandAnnotation.names();
        CommandPartsNode partsNode = this.builder.newCommand(names[0]).aliases(Arrays.asList(Arrays.copyOfRange(names, 1, names.length))).permission(rootCommandAnnotation.permission()).permissionMessage(this.fromString(rootCommandAnnotation.permissionMessage())).description(this.fromString(rootCommandAnnotation.desc())).parts();
        SubCommandsNode subCommandsNode = rootCommandMethod != null ? partsNode.ofMethodParameters(rootCommandMethod, commandClass).action(rootCommandMethod, commandClass) : partsNode.action().action(Action.NULL_ACTION);
        subCommandsNode.setModifiers(clazz.getAnnotations());
        if (!clazz.isAnnotationPresent(Required.class)) {
            subCommandsNode.optional();
        }
        if (clazz.isAnnotationPresent(ArgOrSub.class)) {
            subCommandsNode.argumentsOrSubCommand(clazz.getAnnotation(ArgOrSub.class).value());
        }
        SubCommandClasses classesAnnotation = clazz.getAnnotation(SubCommandClasses.class);
        commandList.addAll(this.getSubCommandFromClasses(commandClass, clazz, classesAnnotation));
        for (me.fixeddev.commandflow.command.Command command : commandList) {
            subCommandsNode.addSubCommand(command);
        }
        for (Method method : clazz.getMethods()) {
            if (!this.isHandlerMethod(method)) continue;
            subCommandsNode.setSubCommandHandler(new ReflectionSubCommandHandler(commandClass, method));
        }
        return Collections.singletonList(subCommandsNode.build());
    }

    private List<me.fixeddev.commandflow.command.Command> getSubCommandFromClasses(CommandClass parentInstance, Class<?> parentClass, SubCommandClasses classesAnnotation) {
        ArrayList<me.fixeddev.commandflow.command.Command> commandList = new ArrayList<me.fixeddev.commandflow.command.Command>();
        if (classesAnnotation == null) {
            return commandList;
        }
        for (Class<? extends CommandClass> subCommandClass : classesAnnotation.value()) {
            if (subCommandClass.equals(parentClass)) continue;
            List<me.fixeddev.commandflow.command.Command> subCommands = this.fromClass(this.instanceCreator.createInstance(subCommandClass, parentInstance));
            commandList.addAll(subCommands);
        }
        return commandList;
    }

    private boolean isHandlerMethod(Method method) {
        if (method.getReturnType() != Void.TYPE || method.getParameterCount() != 3) {
            return false;
        }
        if (!method.isAnnotationPresent(Handler.class)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes[0] == SubCommandPart.HandlerContext.class && parameterTypes[1] == String.class && parameterTypes[2] == me.fixeddev.commandflow.command.Command.class;
    }

    private Component fromString(String component) {
        if (component.startsWith("%translatable:") && component.endsWith("%")) {
            return TranslatableComponent.of(component.substring(14, component.length() - 1));
        }
        return TextComponent.of(component);
    }
}

