/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.annotated.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.fixeddev.commandflow.annotated.CommandClass;
import me.fixeddev.commandflow.annotated.action.ReflectiveAction;
import me.fixeddev.commandflow.annotated.action.ValueGetter;
import me.fixeddev.commandflow.annotated.annotation.Named;
import me.fixeddev.commandflow.annotated.annotation.ParentArg;
import me.fixeddev.commandflow.annotated.annotation.Usage;
import me.fixeddev.commandflow.annotated.builder.CommandActionNode;
import me.fixeddev.commandflow.annotated.builder.CommandDataNode;
import me.fixeddev.commandflow.annotated.builder.CommandPartsNode;
import me.fixeddev.commandflow.annotated.builder.SubCommandsNode;
import me.fixeddev.commandflow.annotated.part.Key;
import me.fixeddev.commandflow.annotated.part.PartFactory;
import me.fixeddev.commandflow.annotated.part.PartInjector;
import me.fixeddev.commandflow.annotated.part.PartModifier;
import me.fixeddev.commandflow.command.Action;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.Parts;
import me.fixeddev.commandflow.part.defaults.SubCommandPart;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandBuilderNodesImpl
implements CommandActionNode,
CommandDataNode,
CommandPartsNode,
SubCommandsNode {
    private final Command.Builder builder;
    private final List<Command> subCommands;
    private final PartInjector injector;
    private final List<ValueGetter> partGetters;
    private SubCommandPart.SubCommandHandler subCommandHandler;
    private boolean optional = false;
    private boolean argumentsOrSubcommand = false;
    private boolean argumentsOrSubcommandReversed = false;
    private Function<CommandPart, CommandPart> modifierFunction = Function.identity();

    public CommandBuilderNodesImpl(String name, PartInjector injector) {
        this.builder = Command.builder(name);
        this.subCommands = new ArrayList<Command>();
        this.partGetters = new ArrayList<ValueGetter>();
        this.injector = injector;
    }

    @Override
    @NotNull
    public CommandPartsNode parts() {
        return this;
    }

    @Override
    @NotNull
    public CommandActionNode action() {
        return this;
    }

    @Override
    @NotNull
    public SubCommandsNode action(@NotNull Method method, @NotNull CommandClass commandClass) {
        return this.action(new ReflectiveAction(this.partGetters, commandClass, method));
    }

    @Override
    @NotNull
    public CommandActionNode ofMethodParameters(@NotNull Method method, @NotNull CommandClass handler) {
        for (Parameter parameter : method.getParameters()) {
            PartFactory factory = this.getFactory(parameter);
            if (factory == null) {
                throw new IllegalStateException("The parameter " + parameter + " of the method " + method.getName() + " doesn't has a valid factory!");
            }
            String name = this.getName(parameter);
            ArrayList<Class<? extends Annotation>> annotationTypes = new ArrayList<Class<? extends Annotation>>();
            List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
            for (Annotation annotation : parameter.getAnnotations()) {
                annotationTypes.add(annotation.annotationType());
            }
            CommandPart part = factory.createPart(name, annotations);
            PartModifier modifier = this.injector.getModifiers(annotationTypes.toArray(new Class[0]));
            ParentArg arg = parameter.getAnnotation(ParentArg.class);
            if (this.getRawType(parameter) == List.class) {
                if (arg != null) {
                    this.partGetters.add(ValueGetter.forPartValues(name, arg.value()));
                } else {
                    this.partGetters.add(ValueGetter.forPartValues(part));
                }
            } else if (this.getRawType(parameter) == Optional.class) {
                if (arg != null) {
                    this.partGetters.add(ValueGetter.forOptionalPart(name, arg.value()));
                } else {
                    this.partGetters.add(ValueGetter.forOptionalPart(part));
                }
            } else if (arg != null) {
                this.partGetters.add(ValueGetter.forPart(name, arg.value()));
            } else {
                this.partGetters.add(ValueGetter.forPart(part));
            }
            if (arg != null) continue;
            part = modifier.modify(part, annotations);
            this.builder.addPart(part);
        }
        return this;
    }

    private Type getRawType(Parameter parameter) {
        if (parameter.getParameterizedType() instanceof ParameterizedType) {
            return ((ParameterizedType)parameter.getParameterizedType()).getRawType();
        }
        return parameter.getType();
    }

    private String getName(Parameter parameter) {
        Named named = parameter.getAnnotation(Named.class);
        return named != null ? named.value() : parameter.getName();
    }

    private PartFactory getFactory(Parameter parameter) {
        Annotation annotation;
        PartFactory factory = null;
        Type type = parameter.getType();
        if (parameter.getParameterizedType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            type = parameterizedType.getRawType() == List.class || parameterizedType.getRawType() == Optional.class ? parameterizedType.getActualTypeArguments()[0] : parameterizedType;
        }
        Annotation[] annotationArray = parameter.getAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n && (factory = this.injector.getFactory(new Key(type, (annotation = annotationArray[i]).annotationType()))) == null; ++i) {
        }
        if (factory != null) {
            return factory;
        }
        return this.injector.getFactory(type);
    }

    @Override
    @NotNull
    public SubCommandsNode action(@NotNull Action action) {
        this.builder.action(action);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode aliases(@NotNull List<String> aliases) {
        this.builder.aliases(aliases);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode addAlias(@NotNull String alias) {
        this.builder.addAlias(alias);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode description(@NotNull Component component) {
        this.builder.description(component);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode usage(@NotNull Component component) {
        this.builder.usage(component);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode usage(@Nullable Usage usageAnnotation) {
        if (usageAnnotation != null) {
            this.builder.usage(this.fromString(usageAnnotation.value()));
        }
        return this;
    }

    private Component fromString(String component) {
        if (component.startsWith("%translatable:") && component.endsWith("%")) {
            return TranslatableComponent.of(component.substring(14, component.length() - 1));
        }
        return TextComponent.of(component);
    }

    @Override
    @NotNull
    public CommandDataNode permission(@NotNull String permission) {
        this.builder.permission(permission);
        return this;
    }

    @Override
    @NotNull
    public CommandDataNode permissionMessage(@NotNull Component permissionMessage) {
        this.builder.permissionMessage(permissionMessage);
        return this;
    }

    @Override
    @NotNull
    public CommandPartsNode addPart(@NotNull CommandPart part) {
        this.builder.addPart(part);
        return this;
    }

    @Override
    public SubCommandsNode addSubCommand(@NotNull Command command) {
        this.subCommands.add(command);
        return this;
    }

    @Override
    public SubCommandsNode addSubCommand(@NotNull CommandDataNode commandDataNode) {
        this.subCommands.add(commandDataNode.build());
        return this;
    }

    @Override
    public SubCommandsNode setSubCommandHandler(SubCommandPart.SubCommandHandler subCommandHandler) {
        if (subCommandHandler == null) {
            throw new IllegalArgumentException("The provided SubCommandHandler shouldn't be null!");
        }
        this.subCommandHandler = subCommandHandler;
        return this;
    }

    @Override
    public SubCommandsNode setModifiers(Annotation ... modifiers) {
        ArrayList<Class<? extends Annotation>> annotationTypes = new ArrayList<Class<? extends Annotation>>();
        List<Annotation> annotations = Arrays.asList(modifiers);
        for (Annotation annotation : modifiers) {
            annotationTypes.add(annotation.annotationType());
        }
        PartModifier modifier = this.injector.getModifiers(annotationTypes);
        if (this.modifierFunction != Function.identity()) {
            Function<CommandPart, CommandPart> oldFunction = this.modifierFunction;
            this.modifierFunction = part -> modifier.modify((CommandPart)oldFunction.apply((CommandPart)part), annotations);
        } else {
            this.modifierFunction = part -> modifier.modify((CommandPart)part, (List<? extends Annotation>)annotations);
        }
        return this;
    }

    @Override
    public SubCommandsNode argumentsOrSubCommand(boolean reversed) {
        this.argumentsOrSubcommand = true;
        this.argumentsOrSubcommandReversed = reversed;
        return this;
    }

    @Override
    public SubCommandsNode optional() {
        this.optional = true;
        return this;
    }

    @Override
    public Command build() {
        if (!this.subCommands.isEmpty()) {
            CommandPart part = this.subCommandHandler != null ? new SubCommandPart("subcommand", this.subCommands, this.optional && !this.argumentsOrSubcommand, this.subCommandHandler) : new SubCommandPart("subcommand", this.subCommands, this.optional && !this.argumentsOrSubcommand);
            part = this.modifierFunction.apply(part);
            if (this.argumentsOrSubcommand) {
                Command command = this.builder.build();
                part = this.argumentsOrSubcommandReversed ? Parts.firstMatch(part.getName() + "|arguments", part, command.getPart()) : Parts.firstMatch(part.getName() + "|arguments", command.getPart(), part);
                this.builder.part(part);
            } else {
                this.builder.addPart(part);
            }
        }
        return this.builder.build();
    }
}

