/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.fixeddev.commandflow.Authorizer;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.CommandManager;
import me.fixeddev.commandflow.ErrorHandler;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.ParseResult;
import me.fixeddev.commandflow.SimpleCommandManager;
import me.fixeddev.commandflow.bukkit.BukkitAuthorizer;
import me.fixeddev.commandflow.bukkit.BukkitCommandWrapper;
import me.fixeddev.commandflow.bukkit.BukkitDefaultTranslationProvider;
import me.fixeddev.commandflow.command.modifiers.FallbackCommandModifiers;
import me.fixeddev.commandflow.exception.ArgumentException;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.CommandException;
import me.fixeddev.commandflow.exception.CommandUsage;
import me.fixeddev.commandflow.exception.InvalidSubCommandException;
import me.fixeddev.commandflow.exception.NoMoreArgumentsException;
import me.fixeddev.commandflow.exception.NoPermissionsException;
import me.fixeddev.commandflow.executor.Executor;
import me.fixeddev.commandflow.input.InputTokenizer;
import me.fixeddev.commandflow.translator.Translator;
import me.fixeddev.commandflow.usage.UsageBuilder;
import net.kyori.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public class BukkitCommandManager
implements CommandManager {
    public static final String SENDER_NAMESPACE = "SENDER";
    protected CommandManager manager;
    protected CommandMap bukkitCommandMap;
    protected final String fallbackPrefix;
    protected final Map<String, BukkitCommandWrapper> wrapperMap;

    public BukkitCommandManager(CommandManager delegate, String fallbackPrefix) {
        this.manager = delegate;
        this.fallbackPrefix = fallbackPrefix;
        this.wrapperMap = new HashMap<String, BukkitCommandWrapper>();
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            this.bukkitCommandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (IllegalAccessException | NoSuchFieldException ex2) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to get command map: ", ex2);
        }
        this.getErrorHandler().addExceptionHandler(CommandUsage.class, (namespace, ex) -> {
            CommandException exceptionToSend = ex;
            if (ex.getCause() instanceof ArgumentParseException) {
                exceptionToSend = (ArgumentParseException)ex.getCause();
            }
            BukkitCommandWrapper.sendMessageToSender(exceptionToSend, namespace);
            return true;
        });
        ErrorHandler.ErrorConsumer<ArgumentException> commonArgumentExceptionConsumer = (namespace, ex) -> {
            BukkitCommandWrapper.sendMessageToSender(ex, namespace);
            return false;
        };
        this.getErrorHandler().addExceptionHandler(InvalidSubCommandException.class, commonArgumentExceptionConsumer);
        this.getErrorHandler().addExceptionHandler(ArgumentParseException.class, commonArgumentExceptionConsumer);
        this.getErrorHandler().addExceptionHandler(NoMoreArgumentsException.class, commonArgumentExceptionConsumer);
        this.getErrorHandler().addExceptionHandler(NoPermissionsException.class, (namespace, throwable) -> {
            BukkitCommandWrapper.sendMessageToSender(throwable, namespace);
            return true;
        });
        this.getErrorHandler().addExceptionHandler(CommandException.class, (namespace, throwable) -> {
            Throwable exceptionToSend = throwable;
            String throwableMessage = throwable.getMessage();
            if (throwableMessage != null && throwableMessage.equals("Internal error.") || throwable.getCause() instanceof CommandException) {
                exceptionToSend = throwable.getCause();
            }
            BukkitCommandWrapper.sendMessageToSender(throwable, namespace);
            String label = namespace.getObject(String.class, "label");
            throw new org.bukkit.command.CommandException("An unexpected exception occurred while executing the command " + label, exceptionToSend);
        });
        this.getErrorHandler().setFallbackHandler((namespace, throwable) -> {
            String label = namespace.getObject(String.class, "label");
            throw new org.bukkit.command.CommandException("An unexpected exception occurred while executing the command " + label, throwable);
        });
    }

    public BukkitCommandManager(String fallbackPrefix) {
        this(new SimpleCommandManager(), fallbackPrefix);
        this.setAuthorizer(new BukkitAuthorizer());
        this.getTranslator().setProvider(new BukkitDefaultTranslationProvider());
        this.getTranslator().setConverterFunction(LegacyComponentSerializer.INSTANCE::deserialize);
    }

    @Override
    public void registerCommand(me.fixeddev.commandflow.command.Command command) {
        this.manager.registerCommand(command);
        BukkitCommandWrapper bukkitCommand = new BukkitCommandWrapper(command, this, this.getTranslator());
        for (String alias : command.getAliases()) {
            this.registerCommand(this.fallbackPrefix + ":" + alias, command);
        }
        this.registerCommand(this.fallbackPrefix + ":" + command.getName(), command);
        this.wrapperMap.put(command.getName(), bukkitCommand);
        this.bukkitCommandMap.register(this.fallbackPrefix, (Command)bukkitCommand);
    }

    @Override
    public void registerCommand(String label, me.fixeddev.commandflow.command.Command command) {
        this.manager.registerCommand(label, command);
    }

    @Override
    public void registerCommands(List<me.fixeddev.commandflow.command.Command> commandList) {
        for (me.fixeddev.commandflow.command.Command command : commandList) {
            this.registerCommand(command);
        }
    }

    @Override
    public void unregisterCommand(me.fixeddev.commandflow.command.Command command) {
        this.manager.unregisterCommand(command);
        BukkitCommandWrapper wrapper = this.wrapperMap.get(command.getName());
        if (wrapper != null) {
            wrapper.unregister(this.bukkitCommandMap);
        }
    }

    @Override
    public void unregisterCommands(List<me.fixeddev.commandflow.command.Command> commands) {
        for (me.fixeddev.commandflow.command.Command command : commands) {
            this.unregisterCommand(command);
        }
    }

    @Override
    public void unregisterAll() {
        Set<me.fixeddev.commandflow.command.Command> commands = this.getCommands();
        for (me.fixeddev.commandflow.command.Command command : commands) {
            this.unregisterCommand(command);
        }
    }

    @Override
    public Set<me.fixeddev.commandflow.command.Command> getCommands() {
        return this.manager.getCommands();
    }

    @Override
    public boolean exists(String commandName) {
        return this.manager.exists(commandName);
    }

    @Override
    public Authorizer getAuthorizer() {
        return this.manager.getAuthorizer();
    }

    @Override
    public void setAuthorizer(Authorizer authorizer) {
        this.manager.setAuthorizer(authorizer);
    }

    @Override
    public InputTokenizer getInputTokenizer() {
        return this.manager.getInputTokenizer();
    }

    @Override
    public void setInputTokenizer(InputTokenizer tokenizer) {
        this.manager.setInputTokenizer(tokenizer);
    }

    @Override
    public Executor getExecutor() {
        return this.manager.getExecutor();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.manager.setExecutor(executor);
    }

    @Override
    public Translator getTranslator() {
        return this.manager.getTranslator();
    }

    @Override
    public void setTranslator(Translator translator) {
        this.manager.setTranslator(translator);
    }

    @Override
    public UsageBuilder getUsageBuilder() {
        return this.manager.getUsageBuilder();
    }

    @Override
    public void setUsageBuilder(UsageBuilder usageBuilder) {
        this.manager.setUsageBuilder(usageBuilder);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.manager.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.manager.setErrorHandler(errorHandler);
    }

    @Override
    public FallbackCommandModifiers getCommandModifiers() {
        return this.manager.getCommandModifiers();
    }

    @Override
    public Optional<me.fixeddev.commandflow.command.Command> getCommand(String commandName) {
        return this.manager.getCommand(commandName);
    }

    @Override
    public boolean execute(Namespace accessor, List<String> arguments) throws CommandException {
        return this.manager.execute(accessor, arguments);
    }

    @Override
    public List<String> getSuggestions(Namespace accessor, List<String> arguments) {
        return this.manager.getSuggestions(accessor, arguments);
    }

    @Override
    public boolean execute(Namespace accessor, String line) throws CommandException {
        return this.manager.execute(accessor, line);
    }

    @Override
    public List<String> getSuggestions(Namespace accessor, String line) {
        return this.manager.getSuggestions(accessor, line);
    }

    @Override
    public boolean execute(CommandContext commandContext) throws CommandException {
        return this.manager.execute(commandContext);
    }

    @Override
    public ParseResult parse(Namespace accessor, List<String> arguments) throws CommandException {
        return this.manager.parse(accessor, arguments);
    }

    @Override
    public ParseResult parse(Namespace accessor, String line) throws CommandException {
        return this.manager.parse(accessor, line);
    }
}

