/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.fixeddev.commandflow.Authorizer;
import me.fixeddev.commandflow.CommandManager;
import me.fixeddev.commandflow.Namespace;
import me.fixeddev.commandflow.NamespaceImpl;
import me.fixeddev.commandflow.SimpleCommandContext;
import me.fixeddev.commandflow.bukkit.MessageUtils;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.exception.CommandException;
import me.fixeddev.commandflow.translator.Translator;
import net.kyori.text.Component;
import net.kyori.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class BukkitCommandWrapper
extends org.bukkit.command.Command {
    protected final CommandManager commandManager;
    protected final Component permissionMessage;
    protected final Translator translator;

    public BukkitCommandWrapper(Command command, CommandManager dispatcher, Translator translator) {
        super(command.getName());
        this.setAliases(command.getAliases());
        SimpleCommandContext fakeContext = new SimpleCommandContext(new NamespaceImpl(), new ArrayList<String>());
        fakeContext.setCommand(command, "<command>");
        this.setUsage(LegacyComponentSerializer.INSTANCE.serialize(dispatcher.getUsageBuilder().getUsage(fakeContext)));
        if (command.getDescription() != null) {
            Component translatedDescription = translator.translate(command.getDescription(), new NamespaceImpl());
            this.setDescription(LegacyComponentSerializer.INSTANCE.serialize(translatedDescription));
        }
        this.setPermission(command.getPermission());
        this.permissionMessage = command.getPermissionMessage();
        this.commandManager = dispatcher;
        this.translator = translator;
    }

    public boolean execute(CommandSender commandSender, String label, String[] args) {
        ArrayList<String> argumentLine = new ArrayList<String>();
        argumentLine.add(label);
        argumentLine.addAll(Arrays.asList(args));
        NamespaceImpl namespace = new NamespaceImpl();
        namespace.setObject(CommandSender.class, "SENDER", commandSender);
        namespace.setObject(String.class, "label", label);
        try {
            return this.commandManager.execute((Namespace)namespace, argumentLine);
        }
        catch (CommandException e) {
            Throwable exceptionToSend = e;
            Throwable cause = e.getCause();
            if (cause instanceof org.bukkit.command.CommandException) {
                throw (org.bukkit.command.CommandException)cause;
            }
            if (cause != null) {
                exceptionToSend = cause;
            }
            throw new org.bukkit.command.CommandException("An unexpected exception occurred while executing the command " + label, exceptionToSend);
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> argumentLine = new ArrayList<String>(Arrays.asList(args));
        argumentLine.add(0, alias);
        NamespaceImpl namespace = new NamespaceImpl();
        namespace.setObject(CommandSender.class, "SENDER", sender);
        return this.commandManager.getSuggestions((Namespace)namespace, argumentLine);
    }

    public boolean testPermission(@NotNull CommandSender target) {
        if (!this.testPermissionSilent(target)) {
            NamespaceImpl namespace = new NamespaceImpl();
            namespace.setObject(CommandSender.class, "SENDER", target);
            Component translatedPermissionMessage = this.translator.translate(this.permissionMessage, namespace);
            BaseComponent[] components = MessageUtils.kyoriToBungee(translatedPermissionMessage);
            MessageUtils.sendMessage(target, components);
            return false;
        }
        return true;
    }

    public boolean testPermissionSilent(CommandSender target) {
        Authorizer authorizer = this.commandManager.getAuthorizer();
        NamespaceImpl namespace = new NamespaceImpl();
        namespace.setObject(CommandSender.class, "SENDER", target);
        return authorizer.isAuthorized(namespace, this.getPermission());
    }

    protected static void sendMessageToSender(CommandException exception, Namespace namespace) {
        CommandManager commandManager = namespace.getObject(CommandManager.class, "commandManager");
        CommandSender sender = namespace.getObject(CommandSender.class, "SENDER");
        Component component = exception.getMessageComponent();
        Component translatedComponent = commandManager.getTranslator().translate(component, namespace);
        BaseComponent[] components = MessageUtils.kyoriToBungee(translatedComponent);
        MessageUtils.sendMessage(sender, components);
    }
}

