/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.ArgumentPart;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import org.bukkit.GameMode;

public class GameModePart
implements ArgumentPart {
    private static final Map<String, GameMode> GAMEMODE_ALIASES = new HashMap<String, GameMode>();
    private final String name;

    public GameModePart(String name) {
        this.name = name;
    }

    public static void addAlias(String alias, GameMode gameMode) {
        GAMEMODE_ALIASES.put(alias, gameMode);
    }

    public List<GameMode> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        String possibleGameModeName = stack.next().toLowerCase();
        GameMode possibleGameMode = GAMEMODE_ALIASES.get(possibleGameModeName);
        if (possibleGameMode == null) {
            throw new ArgumentParseException(TranslatableComponent.of("invalid.gamemode", TextComponent.of(possibleGameModeName)));
        }
        return Collections.singletonList(possibleGameMode);
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        String next;
        String string = next = stack.hasNext() ? stack.next() : null;
        if (next == null) {
            return Collections.emptyList();
        }
        String possibleGameModeName = next.toUpperCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String aliases : GAMEMODE_ALIASES.keySet()) {
            if (!possibleGameModeName.isEmpty() && !aliases.startsWith(possibleGameModeName)) continue;
            suggestions.add(aliases);
        }
        return suggestions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        for (GameMode gameMode : GameMode.values()) {
            GameModePart.addAlias(Integer.toString(gameMode.getValue()), gameMode);
            String gameModeName = gameMode.name().toLowerCase();
            GameModePart.addAlias(gameModeName, gameMode);
            if (gameMode == GameMode.SPECTATOR) {
                GameModePart.addAlias("spec", gameMode);
                GameModePart.addAlias("sp", gameMode);
                continue;
            }
            GameModePart.addAlias(Character.toString(gameModeName.charAt(0)), gameMode);
        }
    }
}

