/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.bukkit.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.ArgumentPart;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OfflinePlayerPart
implements ArgumentPart {
    private final String name;
    private final boolean orSource;

    public OfflinePlayerPart(String name) {
        this(name, false);
    }

    public OfflinePlayerPart(String name, boolean orSource) {
        this.name = name;
        this.orSource = orSource;
    }

    public List<? extends OfflinePlayer> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        Player player;
        if (!stack.hasNext()) {
            player = this.tryGetSender(context);
            if (this.orSource && player != null) {
                return Collections.singletonList(player);
            }
        }
        String target = stack.next();
        try {
            UUID uuid = UUID.fromString(target);
            player = Bukkit.getOfflinePlayer((UUID)uuid);
        }
        catch (IllegalArgumentException ex) {
            player = Bukkit.getOfflinePlayer((String)target);
        }
        if (player == null) {
            player = this.tryGetSender(context);
            if (this.orSource && player != null) {
                return Collections.singletonList(player);
            }
        }
        return Collections.singletonList(player);
    }

    private Player tryGetSender(CommandContext context) {
        CommandSender sender = context.getObject(CommandSender.class, "SENDER");
        if (sender instanceof Player) {
            return (Player)sender;
        }
        return null;
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        return OfflinePlayerPart.getStrings(stack);
    }

    static List<String> getStrings(ArgumentStack stack) {
        String last;
        String string = last = stack.hasNext() ? stack.next() : null;
        if (last == null) {
            return Collections.emptyList();
        }
        if (Bukkit.getPlayerExact((String)last) != null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Player player : Bukkit.matchPlayer((String)last)) {
            names.add(player.getName());
        }
        return names;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OfflinePlayerPart)) {
            return false;
        }
        OfflinePlayerPart that = (OfflinePlayerPart)o;
        return this.orSource == that.orSource && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.orSource);
    }
}

