/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.command;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.command.Action;
import me.fixeddev.commandflow.command.SimpleCommand;
import me.fixeddev.commandflow.command.modifiers.CommandModifiers;
import me.fixeddev.commandflow.part.CommandPart;
import net.kyori.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Command {
    @NotNull
    public String getName();

    @NotNull
    public List<String> getAliases();

    @Nullable
    public Component getDescription();

    @Nullable
    public Component getUsage();

    @Nullable
    public String getPermission();

    @Nullable
    public Component getPermissionMessage();

    @NotNull
    public CommandPart getPart();

    @NotNull
    public CommandModifiers getModifiers();

    @NotNull
    public Action getAction();

    public static Builder builder(String name) {
        return new SimpleCommand.Builder(name);
    }

    public static interface Builder {
        public Builder aliases(List<String> var1);

        default public Builder aliases(String ... aliases) {
            return this.aliases(Arrays.asList(aliases));
        }

        public Builder addAlias(String var1);

        public Builder description(Component var1);

        public Builder usage(Component var1);

        public Builder permission(String var1);

        public Builder permissionMessage(Component var1);

        public Builder part(CommandPart var1);

        public Builder addParts(CommandPart ... var1);

        public Builder addPart(CommandPart var1);

        public Builder modifiers(CommandModifiers var1);

        public Builder action(Action var1);

        default public Builder action(Consumer<CommandContext> action) {
            return this.action((CommandContext context) -> {
                action.accept(context);
                return true;
            });
        }

        public Command build();
    }
}

