/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.command.modifiers;

import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.command.modifiers.CommandModifier;
import me.fixeddev.commandflow.command.modifiers.ModifierPhase;
import me.fixeddev.commandflow.stack.ArgumentStack;

public class SequentialCommandModifier
implements CommandModifier {
    private final List<CommandModifier> modifierList;

    public SequentialCommandModifier(List<CommandModifier> modifierList) {
        this.modifierList = modifierList;
    }

    @Override
    public boolean modify(CommandContext context, ArgumentStack stack, ModifierPhase phase) {
        for (CommandModifier modifier : this.modifierList) {
            if (modifier.modify(context, stack, phase)) continue;
            return false;
        }
        return true;
    }

    public void addModifier(CommandModifier modifier) {
        this.modifierList.add(modifier);
    }

    public void addModifier(int idx, CommandModifier modifier) {
        this.modifierList.add(idx, modifier);
    }

    public void removeModifier(int idx) {
        this.modifierList.remove(idx);
    }

    public void removeModifier(CommandModifier modifier) {
        this.modifierList.remove(modifier);
    }

    public boolean hasModifiers() {
        return !this.modifierList.isEmpty();
    }
}

